/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.util;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.List;

public class TestResourceLoader
extends ClassPathResourceManager {
    public TestResourceLoader(Class<?> testClass) {
        super(testClass.getClassLoader(), testClass.getPackage().getName().replace(".", "/"));
    }

    public Resource getResource(String path) throws IOException {
        final Resource delegate = super.getResource(path);
        if (delegate == null) {
            return delegate;
        }
        return new Resource(){

            public String getPath() {
                return delegate.getPath();
            }

            public Date getLastModified() {
                return new Date(delegate.getLastModified().getTime() + 20L);
            }

            public String getLastModifiedString() {
                return delegate.getLastModifiedString();
            }

            public ETag getETag() {
                return delegate.getETag();
            }

            public String getName() {
                return delegate.getName();
            }

            public boolean isDirectory() {
                return delegate.isDirectory();
            }

            public List<Resource> list() {
                return delegate.list();
            }

            public String getContentType(MimeMappings mimeMappings) {
                return delegate.getContentType(mimeMappings);
            }

            public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
                delegate.serve(sender, exchange, completionCallback);
            }

            public Long getContentLength() {
                return delegate.getContentLength();
            }

            public String getCacheKey() {
                return delegate.getCacheKey();
            }

            public File getFile() {
                return delegate.getFile();
            }

            public File getResourceManagerRoot() {
                return delegate.getResourceManagerRoot();
            }

            public URL getUrl() {
                return delegate.getUrl();
            }
        };
    }
}

