/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.defaultservlet;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.test.defaultservlet.HelloFilter;
import io.undertow.servlet.test.path.ServletPathMappingTestCase;
import io.undertow.servlet.test.util.PathTestServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DefaultServletTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ServletPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new TestResourceLoader(DefaultServletTestCase.class));
        builder.addServlet(new ServletInfo("DefaultTestServlet", PathTestServlet.class).addMapping("/path/default"));
        builder.addServlet(new ServletInfo("default", DefaultServlet.class).addInitParam("directory-listing", "true").addMapping("/*"));
        builder.addFilter(new FilterInfo("Filter", HelloFilter.class));
        builder.addFilterUrlMapping("Filter", "/filterpath/*", DispatcherType.REQUEST);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleResource() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/index.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.contains("Redirected home page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeRequest() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/index.html");
            get.addHeader("range", "bytes=2-3");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"--", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceWithFilter() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/filterpath/filtered.txt");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Hello Stuart", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowedResource() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/disallowed.sh");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryListing() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIfMoodifiedSince() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/index.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.contains("Redirected home page"));
            String lm = result.getHeaders("Last-Modified")[0].getValue();
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/index.html");
            get.addHeader("IF-Modified-Since", lm);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)304L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertFalse((boolean)response.contains("Redirected home page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

