/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.spec;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.spec.ValidCookieEchoServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class GetCookiesTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", ValidCookieEchoServlet.class).addMapping("/aaa");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(GetCookiesTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlet(s);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCookiesWithOnlyValidCookie() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aaa");
            get.setHeader("Cookie", "testcookie=works");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((String)"Only one valid cookie", (Object)"name='testcookie'value='works'", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCookiesWithOnlyInvalidCookies() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aaa");
            get.setHeader("Cookie", "ctx:123=456");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((String)"No valid cookie", (Object)"", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCookiesWithInvalidCookieName() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aaa");
            get.setHeader("Cookie", "testcookie=works; ctx:123=456");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((String)"Only one valid cookie", (Object)"name='testcookie'value='works'", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

