/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AsyncInputStreamServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AsyncContext context = req.startAsync();
        ServletOutputStream outputStream = resp.getOutputStream();
        ServletInputStream inputStream = req.getInputStream();
        MyListener listener = new MyListener(outputStream, inputStream, context);
        inputStream.setReadListener((ReadListener)listener);
        outputStream.setWriteListener((WriteListener)listener);
    }

    private class MyListener
    implements WriteListener,
    ReadListener {
        private final ServletOutputStream outputStream;
        private final ServletInputStream inputStream;
        private final ByteArrayOutputStream dataToWrite = new ByteArrayOutputStream();
        private final AsyncContext context;
        boolean done = false;
        int written = 0;

        MyListener(ServletOutputStream outputStream, ServletInputStream inputStream, AsyncContext context) {
            this.outputStream = outputStream;
            this.inputStream = inputStream;
            this.context = context;
        }

        public void onWritePossible() throws IOException {
            if (this.outputStream.isReady()) {
                this.outputStream.write(this.dataToWrite.toByteArray());
                this.written += this.dataToWrite.toByteArray().length;
                this.dataToWrite.reset();
                if (this.done) {
                    this.context.complete();
                }
            }
        }

        public void onDataAvailable() throws IOException {
            while (this.inputStream.isReady()) {
                int read = this.inputStream.read();
                if (read == 0) {
                    System.out.println("onDataAvailable> read 0x00");
                }
                if (read != -1) {
                    this.dataToWrite.write(read);
                    continue;
                }
                this.onWritePossible();
            }
        }

        public synchronized void onAllDataRead() throws IOException {
            this.done = true;
            this.onWritePossible();
        }

        public synchronized void onError(Throwable t) {
            t.printStackTrace();
        }
    }
}

