/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.basic;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.SendAuthTypeServlet;
import io.undertow.servlet.test.security.SendUsernameServlet;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletBasicAuthTestCase {
    private static final String REALM_NAME = "Servlet_Realm";

    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler path = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo usernameServlet = new ServletInfo("Username Servlet", SendUsernameServlet.class).addMapping("/secured/username");
        ServletInfo authTypeServlet = new ServletInfo("Auth Type Servlet", SendAuthTypeServlet.class).addMapping("/secured/authType");
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "role1");
        identityManager.addUser("charsetUser", "password-\u00fc", "role1");
        LoginConfig loginConfig = new LoginConfig(REALM_NAME);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("charset", "ISO_8859_1");
        props.put("user-agent-charsets", "Chrome,UTF-8,OPR,UTF-8");
        loginConfig.addFirstAuthMethod(new AuthMethodConfig("BASIC", props));
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setIdentityManager((IdentityManager)identityManager).setLoginConfig(loginConfig).addServlets(new ServletInfo[]{usernameServlet, authTypeServlet});
        builder.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/secured/*")).addRoleAllowed("role1")).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.DENY));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)path);
    }

    @Test
    public void testChallengeSent() throws Exception {
        TestHttpClient client = new TestHttpClient();
        String url = DefaultServer.getDefaultServerURL() + "/servletContext/secured/username";
        HttpGet get = new HttpGet(url);
        HttpResponse result = client.execute((HttpUriRequest)get);
        HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith("Basic"));
    }

    @Test
    public void testUserName() throws Exception {
        this.testCall("username", "user1", StandardCharsets.UTF_8, "Chrome", "user1", "password1", 200);
    }

    @Test
    public void testAuthType() throws Exception {
        this.testCall("authType", "BASIC", StandardCharsets.UTF_8, "Chrome", "user1", "password1", 200);
    }

    @Test
    public void testBasicAuthNonAscii() throws Exception {
        this.testCall("authType", "BASIC", StandardCharsets.UTF_8, "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36", "charsetUser", "password-\u00fc", 200);
        this.testCall("authType", "BASIC", StandardCharsets.ISO_8859_1, "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36", "charsetUser", "password-\u00fc", 401);
        this.testCall("authType", "BASIC", StandardCharsets.ISO_8859_1, "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.1", "charsetUser", "password-\u00fc", 200);
        this.testCall("authType", "BASIC", StandardCharsets.UTF_8, "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.1", "charsetUser", "password-\u00fc", 401);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCall(String path, String expectedResponse, Charset charset, String userAgent, String user, String password, int expect) throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            String url = DefaultServer.getDefaultServerURL() + "/servletContext/secured/" + path;
            HttpGet get = new HttpGet(url);
            get = new HttpGet(url);
            get.addHeader("User-Agent", userAgent);
            get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])(user + ":" + password).getBytes(charset), (boolean)false));
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)expect, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            if (expect == 200) {
                Assert.assertEquals((Object)expectedResponse, (Object)response);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

