/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.login;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.SendUsernameServlet;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.security.login.LoginFilter;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletLoginTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler path = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", SendUsernameServlet.class).addMapping("/*");
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "role1");
        identityManager.addUser("user2", "password2", "role2");
        identityManager.addUser("user3", "password3", "role3");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setIdentityManager((IdentityManager)identityManager).setLoginConfig(new LoginConfig("BASIC", "Test Realm")).addServlet(s).addFilter(new FilterInfo("LoginFilter", LoginFilter.class)).addFilterServletNameMapping("LoginFilter", "servlet", DispatcherType.REQUEST);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpMethod() throws IOException {
        TestHttpClient client = new TestHttpClient();
        String url = DefaultServer.getDefaultServerURL() + "/servletContext/login";
        try {
            HttpGet get = new HttpGet(url);
            get.addHeader("username", "bob");
            get.addHeader("password", "bogus");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(url);
            get.addHeader("username", "user1");
            get.addHeader("password", "password1");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"user1", (Object)response);
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"user1", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

