/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.util;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import javax.servlet.ServletException;

public class DeploymentUtils {
    public static Deployment setupServlet(ServletInfo ... servlets) {
        return DeploymentUtils.setupServlet(null, servlets);
    }

    public static Deployment setupServlet(ServletExtension servletExtension, ServletInfo ... servlets) {
        PathHandler pathHandler = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlets(servlets);
        if (servletExtension != null) {
            builder.addServletExtension(servletExtension);
        }
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        try {
            pathHandler.addPrefixPath(builder.getContextPath(), manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        DefaultServer.setRootHandler((HttpHandler)pathHandler);
        return manager.getDeployment();
    }
}

