/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.streams.EarlyCloseClientServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.TestHttpClient;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class ServletInputStreamEarlyCloseClientSideTestCase {
    public static final String SERVLET = "servlet";

    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletInfo(SERVLET, EarlyCloseClientServlet.class).addMapping("/servlet"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletInputStreamEarlyClose() throws Exception {
        TestHttpClient client = new TestHttpClient();
        EarlyCloseClientServlet.reset();
        try (Socket socket = new Socket();){
            socket.connect(DefaultServer.getDefaultServerAddress());
            try {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < 10000; ++i) {
                    sb.append("hello world\r\n");
                }
                String request = "POST /servletContext/servlet HTTP/1.1\r\nHost:localhost\r\nContent-Length:" + sb.length() + 100 + "\r\n\r\n" + sb.toString();
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(request.getBytes("US-ASCII"));
                outputStream.flush();
                socket.close();
                Assert.assertTrue((boolean)EarlyCloseClientServlet.getLatch().await(10L, TimeUnit.SECONDS));
                Assert.assertFalse((boolean)EarlyCloseClientServlet.isCompletedNormally());
                Assert.assertTrue((boolean)EarlyCloseClientServlet.isExceptionThrown());
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
    }
}

