/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.spec;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FilterMappingTestCase {
    public static String message;
    public static final String HELLO_WORLD = "Hello World";
    public static final String SERVLET = "aServlet";
    private Filter filterMappedByServletName = new NullFilter();
    private Filter filterMappedByUrlPattern = new NullFilter();

    @Test
    public void testRegisterFilters() throws Exception {
        this.setupServlet();
    }

    private void setupServlet() {
        DeploymentUtils.setupServlet(new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                servletContext.addFilter("MyFilter1", FilterMappingTestCase.this.filterMappedByServletName).addMappingForServletNames(null, false, new String[]{FilterMappingTestCase.SERVLET});
                servletContext.addFilter("MyFilter2", FilterMappingTestCase.this.filterMappedByUrlPattern).addMappingForUrlPatterns(null, false, new String[]{"/"});
            }
        }, new ServletInfo(SERVLET, NullServlet.class).addMapping("/aServlet"));
    }

    static class NullServlet
    extends HttpServlet {
        NullServlet() {
        }
    }

    static class NullFilter
    implements Filter {
        NullFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            filterChain.doFilter(servletRequest, servletResponse);
        }

        public void destroy() {
        }
    }
}

