/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.crosscontext;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class CrossContextClassLoaderTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("includer", IncludeServlet.class).addMapping("/a");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader((ClassLoader)new TempClassLoader("IncluderClassLoader")).setContextPath("/includer").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("includer.war").addServlet(s);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        s = new ServletInfo("included", IncludedServlet.class).addMapping("/a");
        builder = new DeploymentInfo().setClassLoader((ClassLoader)new TempClassLoader("IncludedClassLoader")).setContextPath("/included").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("included.war").addServlet(s);
        manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrossContextRequest() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/includer/a");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Including Servlet Class Loader: IncluderClassLoader\nIncluding Servlet Context Path: /includer\nIncluded Servlet Class Loader: IncludedClassLoader\nIncluding Servlet Context Path: /included\n", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static final class TempClassLoader
    extends ClassLoader {
        private final String name;

        private TempClassLoader(String name) {
            super(TempClassLoader.class.getClassLoader());
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class IncludedServlet
    extends HttpServlet {
        private IncludedServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().println("Included Servlet Class Loader: " + Thread.currentThread().getContextClassLoader().toString());
            resp.getWriter().println("Including Servlet Context Path: " + req.getServletContext().getContextPath());
        }
    }

    private static final class IncludeServlet
    extends HttpServlet {
        private IncludeServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().println("Including Servlet Class Loader: " + Thread.currentThread().getContextClassLoader().toString());
            resp.getWriter().println("Including Servlet Context Path: " + req.getServletContext().getContextPath());
            ServletContext context = req.getServletContext().getContext("/included");
            context.getRequestDispatcher("/a").include((ServletRequest)req, (ServletResponse)resp);
        }
    }
}

