/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.digest;

import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.DigestAuthorizationToken;
import io.undertow.security.impl.DigestWWWAuthenticateToken;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.SendAuthTypeServlet;
import io.undertow.servlet.test.security.SendUsernameServlet;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DigestAuthTestCase {
    private static final String REALM_NAME = "Servlet_Realm";
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler path = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo usernameServlet = new ServletInfo("Username Servlet", SendUsernameServlet.class).addMapping("/secured/username");
        ServletInfo authTypeServlet = new ServletInfo("Auth Type Servlet", SendAuthTypeServlet.class).addMapping("/secured/authType");
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "role1");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setIdentityManager((IdentityManager)identityManager).setLoginConfig(new LoginConfig("DIGEST", REALM_NAME)).addServlets(new ServletInfo[]{usernameServlet, authTypeServlet});
        builder.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/secured/*")).addRoleAllowed("role1")).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.DENY));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)path);
    }

    @Test
    public void testUserName() throws Exception {
        this.testCall("username", "user1");
    }

    @Test
    public void testAuthType() throws Exception {
        this.testCall("authType", "DIGEST");
    }

    public void testCall(String path, String expectedResponse) throws Exception {
        TestHttpClient client = new TestHttpClient();
        String url = DefaultServer.getDefaultServerURL() + "/servletContext/secured/" + path;
        HttpGet get = new HttpGet(url);
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        Assert.assertTrue((boolean)parsedHeader.containsKey(DigestWWWAuthenticateToken.MESSAGE_QOP));
        String nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        String clientResponse = this.createResponse("user1", REALM_NAME, "password1", "GET", "/", nonce);
        client = new TestHttpClient();
        get = new HttpGet(url);
        StringBuilder sb = new StringBuilder(Headers.DIGEST.toString());
        sb.append(" ");
        sb.append(DigestAuthorizationToken.USERNAME.getName()).append("=").append("\"user1\"").append(",");
        sb.append(DigestAuthorizationToken.REALM.getName()).append("=\"").append(REALM_NAME).append("\",");
        sb.append(DigestAuthorizationToken.NONCE.getName()).append("=\"").append(nonce).append("\",");
        sb.append(DigestAuthorizationToken.DIGEST_URI.getName()).append("=\"/\",");
        sb.append(DigestAuthorizationToken.RESPONSE.getName()).append("=\"").append(clientResponse).append("\"");
        get.addHeader(Headers.AUTHORIZATION.toString(), sb.toString());
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        String response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    private String createResponse(String userName, String realm, String password, String method, String uri, String nonce) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(userName.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(realm.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(password.getBytes(UTF_8));
        byte[] ha1 = HexConverter.convertToHexBytes((byte[])digest.digest());
        digest.update(method.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(uri.getBytes(UTF_8));
        byte[] ha2 = HexConverter.convertToHexBytes((byte[])digest.digest());
        digest.update(ha1);
        digest.update((byte)58);
        digest.update(nonce.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(ha2);
        return HexConverter.convertToHexString((byte[])digest.digest());
    }
}

