/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.request.async.onError;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;

public class AsyncEventListener
implements AsyncListener {
    private static final LinkedBlockingDeque<String> EVENTS = new LinkedBlockingDeque();

    public static String[] results(int expected) {
        ArrayList<String> poll = new ArrayList<String>();
        String current = EVENTS.poll();
        while (current != null) {
            poll.add(current);
            current = EVENTS.poll();
        }
        try {
            if (poll.size() < expected) {
                current = EVENTS.poll(5L, TimeUnit.SECONDS);
                while (current != null) {
                    poll.add(current);
                    if (poll.size() < expected) {
                        current = EVENTS.poll(5L, TimeUnit.SECONDS);
                        continue;
                    }
                    current = EVENTS.poll();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        String[] ret = poll.toArray(new String[poll.size()]);
        EVENTS.clear();
        return ret;
    }

    public void onComplete(AsyncEvent event) throws IOException {
        EVENTS.add("COMPLETE");
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        EVENTS.add("TIMEOUT");
    }

    public void onError(AsyncEvent event) throws IOException {
        EVENTS.add("ERROR");
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
        EVENTS.add("START");
    }
}

