/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.errorpage;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.test.errorpage.ErrorPageTestCase;
import io.undertow.servlet.test.errorpage.PathServlet;
import io.undertow.servlet.test.errorpage.SecureServlet;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SecurityErrorPageTestCase {
    @BeforeClass
    public static void setup() throws IOException, ServletException {
        ServletContainer container = ServletContainer.Factory.newInstance();
        PathHandler root = new PathHandler();
        DefaultServer.setRootHandler((HttpHandler)root);
        DeploymentInfo builder = new DeploymentInfo();
        builder.addServlet(new ServletInfo("secure", SecureServlet.class).addMapping("/secure")).addSecurityConstraint(((SecurityConstraint)Servlets.securityConstraint().addRoleAllowed("user")).addWebResourceCollection(Servlets.webResourceCollection().addUrlPattern("/*")));
        builder.addServlet(new ServletInfo("path", PathServlet.class).addMapping("/*"));
        builder.addErrorPage(new ErrorPage("/401", 401));
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", new String[0]);
        builder.setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ErrorPageTestCase.class.getClassLoader()).setContextPath("/servletContext").setServletStackTraces(ServletStackTraces.NONE).setIdentityManager((IdentityManager)identityManager).setLoginConfig(Servlets.loginConfig((String)"BASIC", (String)"Test Realm")).setDeploymentName("servletContext.war");
        DeploymentManager manager1 = container.addDeployment(builder);
        manager1.deploy();
        root.addPrefixPath(builder.getContextPath(), manager1.start());
    }

    @Test
    public void testErrorPages() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            this.runTest(client, 401, "/401");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void runTest(TestHttpClient client, int statusCode, String expected) throws IOException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/secure");
        CloseableHttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)statusCode, (long)result.getStatusLine().getStatusCode());
        String response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertEquals((Object)expected, (Object)response);
    }
}

