/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.handlers.form.FormData;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;

public class PartImpl
implements Part {
    private final String name;
    private final FormData.FormValue formValue;
    private final MultipartConfigElement config;
    private final ServletContextImpl servletContext;
    private final HttpServletRequestImpl servletRequest;

    public PartImpl(String name, FormData.FormValue formValue, MultipartConfigElement config, ServletContextImpl servletContext, HttpServletRequestImpl servletRequest) {
        this.name = name;
        this.formValue = formValue;
        this.config = config;
        this.servletContext = servletContext;
        this.servletRequest = servletRequest;
    }

    public InputStream getInputStream() throws IOException {
        if (this.formValue.isFile()) {
            return new BufferedInputStream(Files.newInputStream(this.formValue.getPath(), new OpenOption[0]));
        }
        String requestedCharset = this.servletRequest.getCharacterEncoding();
        String charset = requestedCharset != null ? requestedCharset : this.servletContext.getDeployment().getDeploymentInfo().getDefaultEncoding();
        return new ByteArrayInputStream(this.formValue.getValue().getBytes(charset));
    }

    public String getContentType() {
        return this.formValue.getHeaders().getFirst(Headers.CONTENT_TYPE);
    }

    public String getName() {
        return this.name;
    }

    public String getSubmittedFileName() {
        return this.formValue.getFileName();
    }

    public long getSize() {
        try {
            if (this.formValue.isFile()) {
                return Files.size(this.formValue.getPath());
            }
            return this.formValue.getValue().length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(String fileName) throws IOException {
        Path target = Paths.get(fileName, new String[0]);
        if (!target.isAbsolute()) {
            target = this.config.getLocation().isEmpty() ? this.servletContext.getDeployment().getDeploymentInfo().getTempPath().resolve(fileName) : Paths.get(this.config.getLocation(), fileName);
        }
        try {
            Files.move(this.formValue.getPath(), target, new CopyOption[0]);
        }
        catch (IOException e) {
            Files.copy(this.formValue.getPath(), target, new CopyOption[0]);
        }
    }

    public void delete() throws IOException {
        try {
            Files.delete(this.formValue.getPath());
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw UndertowServletMessages.MESSAGES.deleteFailed(this.formValue.getPath());
        }
    }

    public String getHeader(String name) {
        return this.formValue.getHeaders().getFirst(new HttpString(name));
    }

    public Collection<String> getHeaders(String name) {
        HeaderValues values = this.formValue.getHeaders().get(new HttpString(name));
        return values == null ? Collections.emptyList() : values;
    }

    public Collection<String> getHeaderNames() {
        HashSet<String> ret = new HashSet<String>();
        for (HttpString i : this.formValue.getHeaders().getHeaderNames()) {
            ret.add(i.toString());
        }
        return ret;
    }
}

