/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.request.async.onComplete;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OnCompleteServlet
extends HttpServlet {
    public static final BlockingQueue<String> QUEUE = new LinkedBlockingDeque<String>();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        final AsyncContext ctx = req.startAsync();
        ctx.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) throws IOException {
                QUEUE.add("onComplete");
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                QUEUE.add("onTimeout");
            }

            public void onError(AsyncEvent event) throws IOException {
                QUEUE.add("onError");
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
                QUEUE.add("onStartAsync");
            }
        });
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ctx.dispatch("/message");
            }
        });
        thread.start();
    }
}

