/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.Cookie;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.PushBuilder;

public class PushBuilderImpl
implements PushBuilder {
    private static final Set<HttpString> IGNORE;
    private final HttpServletRequestImpl servletRequest;
    private String method;
    private String queryString;
    private String sessionId;
    private final HeaderMap headers = new HeaderMap();
    private String path;

    public PushBuilderImpl(HttpServletRequestImpl servletRequest) {
        this.servletRequest = servletRequest;
        this.method = "GET";
        this.queryString = servletRequest.getQueryString();
        HttpSession session = servletRequest.getSession(false);
        this.sessionId = session != null ? session.getId() : servletRequest.getRequestedSessionId();
        for (HeaderValues header : servletRequest.getExchange().getRequestHeaders()) {
            if (IGNORE.contains(header.getHeaderName())) continue;
            this.headers.addAll(header.getHeaderName(), (Collection)header);
        }
        if (servletRequest.getQueryString() == null) {
            this.headers.add(Headers.REFERER, servletRequest.getRequestURL().toString());
        } else {
            this.headers.add(Headers.REFERER, servletRequest.getRequestURL() + "?" + servletRequest.getQueryString());
        }
        this.path = null;
        for (Map.Entry cookie : servletRequest.getExchange().getResponseCookies().entrySet()) {
            if (Objects.equals(0, ((Cookie)cookie.getValue()).getMaxAge())) {
                HeaderValues existing = this.headers.get(Headers.COOKIE);
                if (existing == null) continue;
                Iterator it = existing.iterator();
                while (it.hasNext()) {
                    String val = (String)it.next();
                    if (!val.startsWith((String)cookie.getKey() + "=")) continue;
                    it.remove();
                }
                continue;
            }
            this.headers.add(Headers.COOKIE, (String)cookie.getKey() + "=" + cookie.getValue());
        }
    }

    public PushBuilder method(String method) {
        this.method = method;
        return this;
    }

    public PushBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public PushBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public PushBuilder setHeader(String name, String value) {
        this.headers.put(new HttpString(name), value);
        return this;
    }

    public PushBuilder addHeader(String name, String value) {
        this.headers.add(new HttpString(name), value);
        return this;
    }

    public PushBuilder removeHeader(String name) {
        this.headers.remove(name);
        return this;
    }

    public PushBuilder path(String path) {
        this.path = path;
        return this;
    }

    public void push() {
        if (this.path == null) {
            throw UndertowServletMessages.MESSAGES.pathWasNotSet();
        }
        ServerConnection con = this.servletRequest.getExchange().getConnection();
        if (con.isPushSupported()) {
            HeaderMap newHeaders = new HeaderMap();
            for (HeaderValues entry : this.headers) {
                newHeaders.addAll(entry.getHeaderName(), (Collection)entry);
            }
            if (this.sessionId != null) {
                newHeaders.put(Headers.COOKIE, "JSESSIONID=" + this.sessionId);
            }
            String path = this.path;
            if (this.queryString != null && !this.queryString.isEmpty()) {
                path = path + "?" + this.queryString;
            }
            con.pushResource(path, new HttpString(this.method), newHeaders);
        }
        this.path = null;
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Set<String> getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        for (HeaderValues name : this.headers) {
            names.add(name.getHeaderName().toString());
        }
        return names;
    }

    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    public String getPath() {
        return this.path;
    }

    static {
        HashSet<HttpString> ignore = new HashSet<HttpString>();
        ignore.add(Headers.IF_MATCH);
        ignore.add(Headers.IF_NONE_MATCH);
        ignore.add(Headers.IF_MODIFIED_SINCE);
        ignore.add(Headers.IF_UNMODIFIED_SINCE);
        ignore.add(Headers.IF_RANGE);
        ignore.add(Headers.RANGE);
        ignore.add(Headers.ACCEPT_RANGES);
        ignore.add(Headers.EXPECT);
        ignore.add(Headers.AUTHORIZATION);
        ignore.add(Headers.REFERER);
        IGNORE = Collections.unmodifiableSet(ignore);
    }
}

