/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.spec;

import io.undertow.servlet.Servlets;
import io.undertow.servlet.test.spec.UnavailableServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class UnavailableServletTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(Servlets.servlet((String)"p", UnavailableServlet.class).addInitParam("permanent", "1").addMapping("/p"), Servlets.servlet((String)"t", UnavailableServlet.class).addMapping("/t"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPermanentUnavailableServlet() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/p");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTempUnavailableServlet() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/t");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)503L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            Thread.sleep(1001L);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/t");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

