/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.charset;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.test.charset.DefaultCharacterEncodingServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DefaultCharacterEncodingTestCase {
    private void setup(final String defaultEncoding) throws ServletException {
        DeploymentUtils.setupServlet(new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                if (defaultEncoding != null) {
                    deploymentInfo.setDefaultEncoding(defaultEncoding);
                }
            }
        }, Servlets.servlet((String)"servlet", DefaultCharacterEncodingServlet.class).addMapping("/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDefaultEncoding(String defaultCharacterEncoding, String expectedRequestCharacterEncoding, String expectedResponseCharacterEncoding) throws IOException, ServletException {
        this.setup(defaultCharacterEncoding);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((String)"Unexpected request character encoding", (Object)expectedRequestCharacterEncoding, (Object)this.readParameter(response, "requestCharacterEncoding"));
            Assert.assertEquals((String)"Unexpected response character encoding", (Object)expectedResponseCharacterEncoding, (Object)this.readParameter(response, "responseCharacterEncoding"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private String readParameter(String response, String parameter) {
        Pattern pattern = Pattern.compile(parameter + "=(.*?);");
        Matcher matcher = pattern.matcher(response);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Test
    public void testDefaultEncodingNotSet() throws IOException, ServletException {
        this.testDefaultEncoding(null, "null", "ISO-8859-1");
    }

    @Test
    public void testDefaultEncodingSetEqualDefault() throws IOException, ServletException {
        this.testDefaultEncoding("ISO-8859-1", "ISO-8859-1", "ISO-8859-1");
    }

    @Test
    public void testDefaultEncodingSetNotEqualDefault() throws IOException, ServletException {
        this.testDefaultEncoding("UTF-8", "UTF-8", "UTF-8");
    }
}

