/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.request.async.onError;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.servlet.api.LoggingExceptionHandler;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.listener.request.async.onError.AsyncEventListener;
import io.undertow.servlet.test.listener.request.async.onError.AsyncServlet1;
import io.undertow.servlet.test.listener.request.async.onError.AsyncServlet2;
import io.undertow.servlet.test.listener.request.async.onError.AsyncServlet3;
import io.undertow.servlet.test.listener.request.async.onError.FaultyServlet;
import io.undertow.servlet.test.listener.request.async.onError.SimpleAsyncListener;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class AsyncListenerOnErrorTest {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo f = new ServletInfo("faultyServlet", FaultyServlet.class).addMapping("/faulty");
        ServletInfo a1 = new ServletInfo("asyncServlet1", AsyncServlet1.class).setAsyncSupported(true).addMapping("/async1");
        ServletInfo a2 = new ServletInfo("asyncServlet2", AsyncServlet2.class).setAsyncSupported(true).addMapping("/async2");
        ServletInfo a3 = new ServletInfo("asyncServlet3", AsyncServlet3.class).setAsyncSupported(true).addMapping("/async3");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(AsyncListenerOnErrorTest.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlets(new ServletInfo[]{f, a1, a2, a3});
        builder.setExceptionHandler((ExceptionHandler)LoggingExceptionHandler.builder().add(IllegalStateException.class, "io.undertow", Logger.Level.DEBUG).build());
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncListenerOnErrorInvoked1() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/async1");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)SimpleAsyncListener.MESSAGE, (Object)response);
            Assert.assertArrayEquals((Object[])new String[]{"ERROR", "COMPLETE"}, (Object[])AsyncEventListener.results(2));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncListenerOnErrorInvoked2() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/async2");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)SimpleAsyncListener.MESSAGE, (Object)response);
            Assert.assertArrayEquals((Object[])new String[]{"ERROR", "COMPLETE"}, (Object[])AsyncEventListener.results(2));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiAsyncDispatchError() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/async3");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)SimpleAsyncListener.MESSAGE, (Object)response);
            Assert.assertArrayEquals((Object[])new String[]{"START", "ERROR", "COMPLETE"}, (Object[])AsyncEventListener.results(3));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

