/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.path;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.path.RealPathServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.nio.file.Paths;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class RealPathTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo realPathServlet = new ServletInfo("real path servlet", RealPathServlet.class).addMapping("/path/*");
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(RealPathTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new TestResourceLoader(RealPathTestCase.class)).addServlets(new ServletInfo[]{realPathServlet});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @Test
    public void testRealPath() throws Exception {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path/real-path");
        CloseableHttpResponse result = new TestHttpClient().execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        String response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertEquals((Object)Paths.get(RealPathTestCase.class.getResource("file.txt").toURI()).toString(), (Object)response);
    }

    @Test
    public void testPathTranslated() throws Exception {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path/file.txt");
        CloseableHttpResponse result = new TestHttpClient().execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        String response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertEquals((Object)Paths.get(RealPathTestCase.class.getResource("file.txt").toURI()).toString(), (Object)response);
    }
}

