/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.request.async;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class AsyncListenerExceptionTest {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo runtime = new ServletInfo("runtime", RuntimeExceptionServlet.class).addMapping("/runtime").setAsyncSupported(true);
        ServletInfo io = new ServletInfo("io", IOExceptionServlet.class).addMapping("/io").setAsyncSupported(true);
        ServletInfo error = new ServletInfo("error", ErrorServlet.class).addMapping("/error").setAsyncSupported(true);
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(AsyncListenerExceptionTest.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlets(new ServletInfo[]{runtime, io, error});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @Before
    public void setUp() {
        AbstractAsyncServlet.QUEUE.clear();
    }

    @Test
    public void onCompleteThrowsRuntimeException() throws IOException, InterruptedException {
        this.doTest("runtime", false);
    }

    @Test
    public void onCompleteThrowsIOException() throws IOException, InterruptedException {
        this.doTest("io", false);
    }

    @Test
    public void onCompleteThrowsError() throws IOException, InterruptedException {
        this.doTest("error", false);
    }

    @Test
    public void onTimeoutThrowsRuntimeException() throws IOException, InterruptedException {
        this.doTest("runtime", true);
    }

    @Test
    public void onTimeoutThrowsIOException() throws IOException, InterruptedException {
        this.doTest("io", true);
    }

    @Test
    public void onTimeoutThrowsError() throws IOException, InterruptedException {
        this.doTest("error", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(String urlTail, boolean timeout) throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/" + urlTail);
            if (timeout) {
                get.addHeader("timeout", "true");
            }
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)(timeout ? 500L : 200L), (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            LinkedList<String> expected = new LinkedList<String>();
            expected.add("onComplete");
            expected.add("onComplete");
            if (timeout) {
                expected.add("onTimeout");
                expected.add("onTimeout");
            }
            LinkedList<String> actual = new LinkedList<String>();
            for (int i = 0; i < expected.size(); ++i) {
                actual.add(AbstractAsyncServlet.QUEUE.poll(10L, TimeUnit.SECONDS));
            }
            actual.sort(Comparator.naturalOrder());
            Assert.assertEquals(expected, actual);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    public static final class ErrorServlet
    extends AbstractAsyncServlet {
        @Override
        protected void throwException() throws IOException {
            throw new Error();
        }
    }

    public static final class IOExceptionServlet
    extends AbstractAsyncServlet {
        @Override
        protected void throwException() throws IOException {
            throw new IOException();
        }
    }

    public static final class RuntimeExceptionServlet
    extends AbstractAsyncServlet {
        @Override
        protected void throwException() throws IOException {
            throw new RuntimeException();
        }
    }

    public static abstract class AbstractAsyncServlet
    extends HttpServlet {
        static final BlockingQueue<String> QUEUE = new LinkedBlockingDeque<String>();

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            AsyncContext context = req.startAsync();
            context.setTimeout(1000L);
            for (int i = 0; i < 2; ++i) {
                context.addListener(new AsyncListener(){

                    public void onComplete(AsyncEvent asyncEvent) throws IOException {
                        QUEUE.add("onComplete");
                        this.throwException();
                    }

                    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
                        QUEUE.add("onTimeout");
                        this.throwException();
                    }

                    public void onError(AsyncEvent asyncEvent) throws IOException {
                        QUEUE.add("onError");
                        this.throwException();
                    }

                    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
                        QUEUE.add("onStartAsync");
                    }
                });
            }
            if (req.getHeader("timeout") == null) {
                context.complete();
            }
        }

        protected abstract void throwException() throws IOException;
    }
}

