/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.request;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.request.RequestPathServlet;
import io.undertow.servlet.test.util.SetHeaderFilter;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.util.ArrayList;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class RequestPathTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler pathHandler = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlets(new ServletInfo[]{new ServletInfo("request", RequestPathServlet.class).addMapping("/req/*"), new ServletInfo("DefaultServlet", RequestPathServlet.class).addMapping("/"), new ServletInfo("ExactServlet", RequestPathServlet.class).addMapping("/exact"), new ServletInfo("ExactTxtServlet", RequestPathServlet.class).addMapping("/exact.txt"), new ServletInfo("HtmlServlet", RequestPathServlet.class).addMapping("*.html")}).addFilters(new FilterInfo[]{new FilterInfo("header", SetHeaderFilter.class).addInitParam("header", "Filter").addInitParam("value", "true"), new FilterInfo("all", SetHeaderFilter.class).addInitParam("header", "all").addInitParam("value", "true")}).addFilterUrlMapping("header", "*.txt", DispatcherType.REQUEST).addFilterUrlMapping("all", "/*", DispatcherType.REQUEST);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        try {
            pathHandler.addPrefixPath(builder.getContextPath(), manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        DefaultServer.setRootHandler((HttpHandler)pathHandler);
    }

    @Test
    public void testRequestPaths() throws Exception {
        int port = DefaultServer.getHostPort((String)"default");
        String hostAddress = DefaultServer.getHostAddress();
        this.runtest("/servletContext/somePath", false, "null", "/somePath", "http://" + hostAddress + ":" + port + "/servletContext/somePath", "/servletContext/somePath", "");
        this.runtest("/servletContext/somePath?foo=bar", false, "null", "/somePath", "http://" + hostAddress + ":" + port + "/servletContext/somePath", "/servletContext/somePath", "foo=bar");
        this.runtest("/servletContext/somePath?foo=b+a+r", false, "null", "/somePath", "http://" + hostAddress + ":" + port + "/servletContext/somePath", "/servletContext/somePath", "foo=b+a+r");
        this.runtest("/servletContext/some%20path?foo=b+a+r", false, "null", "/some path", "http://" + hostAddress + ":" + port + "/servletContext/some%20path", "/servletContext/some%20path", "foo=b+a+r");
        this.runtest("/servletContext/somePath.txt", true, "null", "/somePath.txt", "http://" + hostAddress + ":" + port + "/servletContext/somePath.txt", "/servletContext/somePath.txt", "");
        this.runtest("/servletContext/somePath.txt?foo=bar", true, "null", "/somePath.txt", "http://" + hostAddress + ":" + port + "/servletContext/somePath.txt", "/servletContext/somePath.txt", "foo=bar");
        this.runtest("/servletContext/req/somePath", false, "/somePath", "/req", "http://" + hostAddress + ":" + port + "/servletContext/req/somePath", "/servletContext/req/somePath", "");
        this.runtest("/servletContext/req/somePath?foo=bar", false, "/somePath", "/req", "http://" + hostAddress + ":" + port + "/servletContext/req/somePath", "/servletContext/req/somePath", "foo=bar");
        this.runtest("/servletContext/req/somePath?foo=b+a+r", false, "/somePath", "/req", "http://" + hostAddress + ":" + port + "/servletContext/req/somePath", "/servletContext/req/somePath", "foo=b+a+r");
        this.runtest("/servletContext/req/some%20path?foo=b+a+r", false, "/some path", "/req", "http://" + hostAddress + ":" + port + "/servletContext/req/some%20path", "/servletContext/req/some%20path", "foo=b+a+r");
        this.runtest("/servletContext/req/somePath.txt", true, "/somePath.txt", "/req", "http://" + hostAddress + ":" + port + "/servletContext/req/somePath.txt", "/servletContext/req/somePath.txt", "");
        this.runtest("/servletContext/req/somePath.txt?foo=bar", true, "/somePath.txt", "/req", "http://" + hostAddress + ":" + port + "/servletContext/req/somePath.txt", "/servletContext/req/somePath.txt", "foo=bar");
        this.runtest("/servletContext/exact", false, "null", "/exact", "http://" + hostAddress + ":" + port + "/servletContext/exact", "/servletContext/exact", "");
        this.runtest("/servletContext/exact?foo=bar", false, "null", "/exact", "http://" + hostAddress + ":" + port + "/servletContext/exact", "/servletContext/exact", "foo=bar");
        this.runtest("/servletContext/exact.txt", true, "null", "/exact.txt", "http://" + hostAddress + ":" + port + "/servletContext/exact.txt", "/servletContext/exact.txt", "");
        this.runtest("/servletContext/exact.txt?foo=bar", true, "null", "/exact.txt", "http://" + hostAddress + ":" + port + "/servletContext/exact.txt", "/servletContext/exact.txt", "foo=bar");
        this.runtest("/servletContext/file.html", false, "null", "/file.html", "http://" + hostAddress + ":" + port + "/servletContext/file.html", "/servletContext/file.html", "");
        this.runtest("/servletContext/file.html?foo=bar", false, "null", "/file.html", "http://" + hostAddress + ":" + port + "/servletContext/file.html", "/servletContext/file.html", "foo=bar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runtest(String request, boolean filterHeader, String ... expectedBody) throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + request);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertArrayEquals((Object[])expectedBody, (Object[])RequestPathTestCase.split(response));
            Assert.assertEquals((Object)"true", (Object)result.getHeaders("all")[0].getValue());
            if (filterHeader) {
                Assert.assertEquals((Object)"true", (Object)result.getHeaders("Filter")[0].getValue());
            } else {
                Assert.assertEquals((long)0L, (long)result.getHeaders("Filter").length);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static String[] split(String s) {
        ArrayList<String> strings = new ArrayList<String>();
        int pos = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != ',') continue;
            strings.add(s.substring(pos, i));
            pos = i + 1;
        }
        strings.add(s.substring(pos));
        return strings.toArray(new String[strings.size()]);
    }
}

