/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.basic;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.X509CertificateCredential;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.SendAuthTypeServlet;
import io.undertow.servlet.test.security.SendUsernameServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletClientCertAuthTestCase {
    private static final String REALM_NAME = "Servlet_Realm";
    protected static final IdentityManager identityManager;
    private static SSLContext clientSSLContext;

    @BeforeClass
    public static void startSSL() throws Exception {
    }

    @AfterClass
    public static void stopSSL() throws Exception {
        clientSSLContext = null;
        DefaultServer.stopSSLServer();
    }

    @BeforeClass
    public static void setup() throws ServletException, IOException {
        DefaultServer.startSSLServer();
        clientSSLContext = DefaultServer.getClientSSLContext();
        PathHandler path = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo usernameServlet = new ServletInfo("Username Servlet", SendUsernameServlet.class).addMapping("/secured/username");
        ServletInfo authTypeServlet = new ServletInfo("Auth Type Servlet", SendAuthTypeServlet.class).addMapping("/secured/authType");
        LoginConfig loginConfig = new LoginConfig(REALM_NAME);
        loginConfig.addFirstAuthMethod(new AuthMethodConfig("CLIENT_CERT"));
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setIdentityManager(identityManager).setLoginConfig(loginConfig).addServlets(new ServletInfo[]{usernameServlet, authTypeServlet});
        builder.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/secured/*")).addRoleAllowed("role1")).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.DENY));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)path);
    }

    @Test
    public void testUserName() throws Exception {
        this.testCall("username", "CN=Test Client,OU=OU,O=Org,L=City,ST=State,C=GB", 200);
    }

    @Test
    public void testAuthType() throws Exception {
        this.testCall("authType", "CLIENT_CERT", 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCall(String path, String expectedResponse, int expect) throws Exception {
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(clientSSLContext);
        try {
            String url = DefaultServer.getDefaultServerSSLAddress() + "/servletContext/secured/" + path;
            HttpGet get = new HttpGet(url);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)expect, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            if (expect == 200) {
                Assert.assertEquals((Object)expectedResponse, (Object)response);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    static {
        final HashSet<String> certUsers = new HashSet<String>();
        certUsers.add("CN=Test Client,OU=OU,O=Org,L=City,ST=State,C=GB");
        identityManager = new IdentityManager(){

            public Account verify(Account account) {
                return account;
            }

            public Account verify(String id, Credential credential) {
                return null;
            }

            public Account verify(Credential credential) {
                X500Principal p;
                if (credential instanceof X509CertificateCredential && certUsers.contains((p = ((X509CertificateCredential)credential).getCertificate().getSubjectX500Principal()).getName())) {
                    return new Account(){

                        public Principal getPrincipal() {
                            return p;
                        }

                        public Set<String> getRoles() {
                            return Collections.singleton("role1");
                        }
                    };
                }
                return null;
            }
        };
    }
}

