/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.junit.Test;

public class HandlerListingTestCase {
    @Test
    public void listHandlers() {
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("handlers");
        ArrayList<HandlerBuilder> builds = new ArrayList<HandlerBuilder>();
        for (HandlerBuilder i : ServiceLoader.load(HandlerBuilder.class, this.getClass().getClassLoader())) {
            builds.add(i);
        }
        Collections.sort(builds, new Comparator<HandlerBuilder>(){

            @Override
            public int compare(HandlerBuilder o1, HandlerBuilder o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        for (HandlerBuilder handler : builds) {
            System.out.print("|" + handler.name());
            System.out.print("\t|");
            ArrayList parms = new ArrayList(handler.parameters().keySet());
            Collections.sort(parms);
            Iterator it = parms.iterator();
            while (it.hasNext()) {
                String paramName = (String)it.next();
                System.out.print(paramName + ": ");
                Class obj = (Class)handler.parameters().get(paramName);
                if (obj == ExchangeAttribute.class) {
                    System.out.print("attribute");
                } else if (obj.equals(ExchangeAttribute[].class)) {
                    System.out.print("attribute[]");
                } else if (obj.equals(String.class)) {
                    System.out.print("String");
                } else if (obj.equals(String[].class)) {
                    System.out.print("String[]");
                } else if (obj.equals(Long.class)) {
                    System.out.print("Long");
                } else if (obj.equals(Long[].class)) {
                    System.out.print("Long[]");
                } else if (obj.equals(Boolean.class)) {
                    System.out.print("Boolean");
                } else {
                    System.out.print(obj);
                }
                if (handler.requiredParameters() != null && handler.requiredParameters().contains(paramName)) {
                    System.out.print(" (required)");
                }
                if (!it.hasNext()) continue;
                System.out.print(", ");
            }
            System.out.print("\t|");
            if (handler.defaultParameter() != null) {
                System.out.print(handler.defaultParameter());
            }
            System.out.print("\t|\n");
        }
    }

    @Test
    public void listPredicates() {
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("predicates");
        ArrayList<PredicateBuilder> builds = new ArrayList<PredicateBuilder>();
        for (PredicateBuilder i : ServiceLoader.load(PredicateBuilder.class, this.getClass().getClassLoader())) {
            builds.add(i);
        }
        Collections.sort(builds, new Comparator<PredicateBuilder>(){

            @Override
            public int compare(PredicateBuilder o1, PredicateBuilder o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        for (PredicateBuilder handler : builds) {
            System.out.print("|" + handler.name());
            System.out.print("\t|");
            ArrayList parms = new ArrayList(handler.parameters().keySet());
            Collections.sort(parms);
            Iterator it = parms.iterator();
            while (it.hasNext()) {
                String paramName = (String)it.next();
                System.out.print(paramName + ": ");
                Class obj = (Class)handler.parameters().get(paramName);
                if (obj == ExchangeAttribute.class) {
                    System.out.print("attribute");
                } else if (obj.equals(ExchangeAttribute[].class)) {
                    System.out.print("attribute[]");
                } else if (obj.equals(String.class)) {
                    System.out.print("String");
                } else if (obj.equals(String[].class)) {
                    System.out.print("String[]");
                } else if (obj.equals(Long.class)) {
                    System.out.print("Long");
                } else if (obj.equals(Long[].class)) {
                    System.out.print("Long[]");
                } else if (obj.equals(Boolean.class)) {
                    System.out.print("Boolean");
                } else {
                    System.out.print(obj);
                }
                if (handler.requiredParameters().contains(paramName)) {
                    System.out.print(" (required)");
                }
                if (!it.hasNext()) continue;
                System.out.print(", ");
            }
            System.out.print("\t|");
            if (handler.defaultParameter() != null) {
                System.out.print(handler.defaultParameter());
            }
            System.out.print("\t|\n");
        }
    }
}

