/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.listener.session.SessionServlet;
import io.undertow.servlet.test.listener.session.SimpleSessionListener;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletSessionInvalidateWithListenerTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler path = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/listener").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("listener.war").addListener(new ListenerInfo(SimpleSessionListener.class)).addServlet(new ServletInfo("servlet", SessionServlet.class).addMapping("/test"));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleSessionUsage() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/listener/test");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

