/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.request;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.request.RedirectServlet;
import io.undertow.servlet.test.request.RequestPathServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.util.ArrayList;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class RedirectTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler pathHandler = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlets(new ServletInfo[]{Servlets.servlet((String)"request", RequestPathServlet.class).addMapping("/"), Servlets.servlet((String)"redirect", RedirectServlet.class).addMapping("/redirect/*")});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        try {
            pathHandler.addPrefixPath(builder.getContextPath(), manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        DefaultServer.setRootHandler((HttpHandler)pathHandler);
    }

    @Test
    public void testServletRedirect() throws Exception {
        int port = DefaultServer.getHostPort((String)"default");
        this.runtest("/servletContext/redirect/foo?redirect=../bar", "null", "/bar", "http://" + DefaultServer.getHostAddress() + ":" + port + "/servletContext/bar", "/servletContext/bar", "");
        this.runtest("/servletContext/redirect/foo/?redirect=../../bar", "null", "/bar", "http://" + DefaultServer.getHostAddress() + ":" + port + "/servletContext/bar", "/servletContext/bar", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runtest(String request, String ... expectedBody) throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + request);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertArrayEquals((Object[])expectedBody, (Object[])RedirectTestCase.split(response));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static String[] split(String s) {
        ArrayList<String> strings = new ArrayList<String>();
        int pos = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != ',') continue;
            strings.add(s.substring(pos, i));
            pos = i + 1;
        }
        strings.add(s.substring(pos));
        return strings.toArray(new String[strings.size()]);
    }
}

