/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.streams.AsyncOutputStreamServlet;
import io.undertow.servlet.test.streams.BlockingOutputStreamServlet;
import io.undertow.servlet.test.streams.ContentLengthCloseFlushServlet;
import io.undertow.servlet.test.streams.ResetBufferServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletOutputStreamTestCase {
    public static String message;
    public static final String HELLO_WORLD = "Hello World";
    public static final String BLOCKING_SERVLET = "blockingOutput";
    public static final String ASYNC_SERVLET = "asyncOutput";
    public static final String CONTENT_LENGTH_SERVLET = "contentLength";
    public static final String RESET = "reset";
    public static final String START = "START";
    public static final String END = "END";

    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                deploymentInfo.setIgnoreFlush(false);
            }
        }, new ServletInfo(BLOCKING_SERVLET, BlockingOutputStreamServlet.class).addMapping("/blockingOutput"), new ServletInfo(ASYNC_SERVLET, AsyncOutputStreamServlet.class).addMapping("/asyncOutput").setAsyncSupported(true), new ServletInfo(CONTENT_LENGTH_SERVLET, ContentLengthCloseFlushServlet.class).addMapping("/contentLength"), new ServletInfo(RESET, ResetBufferServlet.class).addMapping("/reset"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAndCloseWithContentLength() throws Exception {
        TestHttpClient client = this.createClient();
        try {
            String uri = this.getBaseUrl() + "/servletContext/" + CONTENT_LENGTH_SERVLET;
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"a", (Object)response);
            get = new HttpGet(uri);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"OK", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    protected TestHttpClient createClient() {
        return new TestHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResetBuffer() throws Exception {
        TestHttpClient client = this.createClient();
        try {
            String uri = this.getBaseUrl() + "/servletContext/" + RESET;
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"hello world", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testBlockingServletOutputStream() throws IOException {
        Assume.assumeFalse((boolean)DefaultServer.isH2upgrade());
        message = "STARTHello WorldEND";
        this.runTest(message, BLOCKING_SERVLET, false, true, 1, true, false, false);
        StringBuilder builder = new StringBuilder(1000 * HELLO_WORLD.length());
        builder.append(START);
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 1000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString() + END;
                this.runTest(message, BLOCKING_SERVLET, false, false, 1, false, false, false);
                this.runTest(message, BLOCKING_SERVLET, true, false, 10, false, false, false);
                this.runTest(message, BLOCKING_SERVLET, false, true, 3, false, false, false);
                this.runTest(message, BLOCKING_SERVLET, true, true, 7, false, false, false);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Test
    public void testChunkedResponseWithInitialFlush() throws IOException {
        message = "STARTHello WorldEND";
        this.runTest(message, BLOCKING_SERVLET, false, true, 1, true, false, false);
    }

    @Test
    public void testAsyncServletOutputStream() {
        Assume.assumeFalse((boolean)DefaultServer.isH2upgrade());
        StringBuilder builder = new StringBuilder(1000 * HELLO_WORLD.length());
        builder.append(START);
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 10000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString() + END;
                this.runTest(message, ASYNC_SERVLET, false, false, 1, false, false, false);
                this.runTest(message, ASYNC_SERVLET, true, false, 10, false, false, false);
                this.runTest(message, ASYNC_SERVLET, false, true, 3, false, false, false);
                this.runTest(message, ASYNC_SERVLET, true, true, 7, false, false, false);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Test
    public void testAsyncServletOutputStreamOffIOThread() {
        Assume.assumeFalse((boolean)DefaultServer.isH2upgrade());
        StringBuilder builder = new StringBuilder(1000 * HELLO_WORLD.length());
        builder.append(START);
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 10000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString() + END;
                this.runTest(message, ASYNC_SERVLET, false, false, 1, false, false, true);
                this.runTest(message, ASYNC_SERVLET, true, false, 10, false, false, true);
                this.runTest(message, ASYNC_SERVLET, false, true, 3, false, false, true);
                this.runTest(message, ASYNC_SERVLET, true, true, 7, false, false, true);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Test
    public void testAsyncServletOutputStreamWithPreableOffIOThread() {
        Assume.assumeFalse((boolean)DefaultServer.isH2upgrade());
        StringBuilder builder = new StringBuilder(1000 * HELLO_WORLD.length());
        builder.append(START);
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 10000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString() + END;
                this.runTest(message, ASYNC_SERVLET, false, false, 1, false, true, true);
                this.runTest(message, ASYNC_SERVLET, true, false, 10, false, true, true);
                this.runTest(message, ASYNC_SERVLET, false, true, 3, false, true, true);
                this.runTest(message, ASYNC_SERVLET, true, true, 7, false, true, true);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Test
    public void testAsyncServletOutputStreamWithPreable() {
        Assume.assumeFalse((boolean)DefaultServer.isH2upgrade());
        StringBuilder builder = new StringBuilder(1000 * HELLO_WORLD.length());
        builder.append(START);
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 10000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString() + END;
                this.runTest(message, ASYNC_SERVLET, false, false, 1, false, true, false);
                this.runTest(message, ASYNC_SERVLET, true, false, 10, false, true, false);
                this.runTest(message, ASYNC_SERVLET, false, true, 3, false, true, false);
                this.runTest(message, ASYNC_SERVLET, true, true, 7, false, true, false);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String message, String url, boolean flush, boolean close, int reps, boolean initialFlush, boolean writePreable, boolean offIoThread) throws IOException {
        TestHttpClient client = this.createClient();
        try {
            String response;
            ServletOutputStreamTestCase.message = message;
            String uri = this.getBaseUrl() + "/servletContext/" + url + "?reps=" + reps + "&";
            if (flush) {
                uri = uri + "flush=true&";
            }
            if (close) {
                uri = uri + "close=true&";
            }
            if (initialFlush) {
                uri = uri + "initialFlush=true&";
            }
            if (writePreable) {
                uri = uri + "preamble=true&";
            }
            if (offIoThread) {
                uri = uri + "offIoThread=true&";
            }
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            StringBuilder builder = new StringBuilder(reps * message.length());
            for (int j = 0; j < reps; ++j) {
                builder.append(message);
            }
            if (writePreable) {
                builder.append(builder.toString());
            }
            try {
                response = HttpClientUtils.readResponse((HttpResponse)result);
            }
            catch (ConnectionClosedException prematureEndOfChunkException) {
                Assert.assertEquals((Object)"Premature end of chunk coded message body: closing chunk expected", (Object)prematureEndOfChunkException.getMessage());
                client.getConnectionManager().shutdown();
                return;
            }
            String expected = builder.toString();
            Assert.assertTrue((String)"Must start with START", (boolean)response.startsWith(START));
            Assert.assertTrue((String)"Must end with END", (boolean)response.endsWith(END));
            Assert.assertEquals((long)expected.length(), (long)response.length());
            Assert.assertEquals((Object)expected, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    protected String getBaseUrl() {
        return DefaultServer.getDefaultServerURL();
    }
}

