/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.path;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.path.GetMappingServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class MappingTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletInfo("path", GetMappingServlet.class).addMapping("/path/*").addMapping("/exact").addMapping("*.ext").addMapping("").addMapping("/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMapping() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path/foo");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Mapping match:PATH\nMatch value:foo\nPattern:/path/*\nServlet:path", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/foo.ext");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Mapping match:EXTENSION\nMatch value:foo\nPattern:*.ext\nServlet:path", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Mapping match:CONTEXT_ROOT\nMatch value:\nPattern:\nServlet:path", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/doesnotexist");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Mapping match:DEFAULT\nMatch value:\nPattern:/\nServlet:path", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/exact");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Mapping match:EXACT\nMatch value:exact\nPattern:/exact\nServlet:path", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

