/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.handlers.RequestBufferingHandler;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.streams.AbstractServletInputStreamTestCase;
import io.undertow.servlet.test.streams.AsyncInputStreamServlet;
import io.undertow.servlet.test.streams.BlockingInputStreamServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import javax.servlet.ServletContext;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletInputStreamRequestBufferingTestCase
extends AbstractServletInputStreamTestCase {
    @BeforeClass
    public static void setup() {
        DeploymentUtils.setupServlet(new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                deploymentInfo.addInitialHandlerChainWrapper((HandlerWrapper)new RequestBufferingHandler.Wrapper(1));
            }
        }, new ServletInfo("blockingInput", BlockingInputStreamServlet.class).addMapping("/blockingInput"), new ServletInfo("asyncInput", AsyncInputStreamServlet.class).addMapping("/asyncInput").setAsyncSupported(true));
    }

    @Override
    @Test
    public void testAsyncServletInputStreamInParallel() throws Exception {
        Assume.assumeFalse((boolean)DefaultServer.isH2upgrade());
        super.testAsyncServletInputStreamInParallel();
    }

    @Override
    @Test
    public void testAsyncServletInputStreamInParallelOffIoThread() throws Exception {
        Assume.assumeFalse((boolean)DefaultServer.isH2upgrade());
        super.testAsyncServletInputStreamInParallelOffIoThread();
    }
}

