/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.servletcontext;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.listener.servletcontext.CheckRolesServlet;
import io.undertow.servlet.test.listener.servletcontext.DeclareRolesServletContextListener;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletContextRolesTestCase {
    private static final String REALM_NAME = "Servlet_Realm-1";
    static DeploymentManager manager;

    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "unspecified-role");
        LoginConfig loginConfig = new LoginConfig(REALM_NAME);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("charset", "ISO_8859_1");
        props.put("user-agent-charsets", "Chrome,UTF-8,OPR,UTF-8");
        loginConfig.addFirstAuthMethod(new AuthMethodConfig("BASIC", props));
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(ServletContextRolesTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlet(new ServletInfo("servlet", CheckRolesServlet.class).addMapping("/aa")).addListener(new ListenerInfo(DeclareRolesServletContextListener.class)).setIdentityManager((IdentityManager)identityManager).setLoginConfig(loginConfig);
        builder.addPrincipalVsRoleMappings("user1", DeclareRolesServletContextListener.ROLES);
        builder.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/*")).addRolesAllowed(DeclareRolesServletContextListener.ROLES)).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.DENY));
        manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @Test
    public void testRoles() throws Exception {
        StringBuilder sb = new StringBuilder(40);
        sb.append("dobby:true\n").append("was:true\n").append("here:true\n");
        this.testCall(sb.toString(), StandardCharsets.UTF_8, "Chrome", "user1", "password1", 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCall(String expectedResponse, Charset charset, String userAgent, String user, String password, int expect) throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            String url = DefaultServer.getDefaultServerURL() + "/servletContext/aa";
            HttpGet get = new HttpGet(url);
            get = new HttpGet(url);
            get.addHeader("User-Agent", userAgent);
            get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])(user + ":" + password).getBytes(charset), (boolean)false));
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)expect, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            if (expect == 200) {
                Assert.assertEquals((Object)expectedResponse, (Object)response);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

