/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.async;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.test.async.AnotherAsyncServlet;
import io.undertow.servlet.test.async.AsyncDispatchPathTestServlet;
import io.undertow.servlet.test.async.AsyncDispatchServlet;
import io.undertow.servlet.test.async.AsyncDoubleCompleteServlet;
import io.undertow.servlet.test.async.AsyncErrorListenerServlet;
import io.undertow.servlet.test.async.AsyncErrorServlet;
import io.undertow.servlet.test.async.AsyncServlet;
import io.undertow.servlet.test.async.SimpleDateThreadLocalAsyncServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.servlet.test.util.MessageServlet;
import io.undertow.servlet.test.util.ParameterEchoServlet;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SimpleAsyncTestCase {
    public static final String HELLO_WORLD = "Hello World";

    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                deploymentInfo.setServletStackTraces(ServletStackTraces.NONE);
                deploymentInfo.addErrorPages(new ErrorPage[]{new ErrorPage("/500", 500)});
                deploymentInfo.addThreadSetupAction((ThreadSetupHandler)new SimpleDateThreadSetupHandler());
            }
        }, Servlets.servlet((String)"messageServlet", MessageServlet.class).addInitParam("message", HELLO_WORLD).setAsyncSupported(true).addMapping("/message"), Servlets.servlet((String)"500", MessageServlet.class).addInitParam("message", "500").setAsyncSupported(true).addMapping("/500"), Servlets.servlet((String)"asyncServlet", AsyncServlet.class).addInitParam("message", HELLO_WORLD).setAsyncSupported(true).addMapping("/async"), Servlets.servlet((String)"asyncServlet2", AnotherAsyncServlet.class).setAsyncSupported(true).addMapping("/async2"), Servlets.servlet((String)"error", AsyncErrorServlet.class).setAsyncSupported(true).addMapping("/error"), Servlets.servlet((String)"errorlistener", AsyncErrorListenerServlet.class).setAsyncSupported(true).addMapping("/errorlistener"), Servlets.servlet((String)"dispatch", AsyncDispatchServlet.class).setAsyncSupported(true).addMapping("/dispatch").addMapping("/dispatch/*").addMapping("*.dispatch"), Servlets.servlet((String)"asyncPath", AsyncDispatchPathTestServlet.class).setAsyncSupported(true).addMapping("/pathinfo").addMapping("/pathinfo/*").addMapping("*.info"), Servlets.servlet((String)"parameterEcho", ParameterEchoServlet.class).setAsyncSupported(true).addMapping("/echo-parameters"), Servlets.servlet((String)"doubleCompleteServlet", AsyncDoubleCompleteServlet.class).setAsyncSupported(true).addMapping("/double-complete"), Servlets.servlet((String)"simpleDateThreadLocal", SimpleDateThreadLocalAsyncServlet.class).setAsyncSupported(true).addMapping("/simple-date-thread-local"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleHttpServlet() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/async");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)HELLO_WORLD, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleHttpAsyncServletWithoutDispatch() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/async2");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)AnotherAsyncServlet.class.getSimpleName(), (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorServlet() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/error");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)500L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"500", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorListenerServlet() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/errorlistener");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)500L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"500", (Object)response);
            Assert.assertEquals((Object)"ERROR", (Object)AsyncErrorListenerServlet.EVENTS.poll(10L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)"COMPLETED", (Object)AsyncErrorListenerServlet.EVENTS.poll(10L, TimeUnit.SECONDS));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrappedDispatch() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"wrapped: Hello World", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorServletWithPostData() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/error");
            post.setEntity((HttpEntity)new StringEntity("Post body stuff"));
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)500L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"500", (Object)response);
            post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/error");
            post.setEntity((HttpEntity)new StringEntity("Post body stuff"));
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)500L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"500", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletCompletesTwiceOnInitialThread() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/double-complete");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)HELLO_WORLD, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleDateThreahLocalAsyncServlet() throws IOException, ParseException {
        TestHttpClient client = new TestHttpClient();
        try {
            Date start = new Date();
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/simple-date-thread-local");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((String)"Response status is not OK", (long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertNotEquals((String)"Date thread-local was not found", (Object)"NULL_THREAD_LOCAL", (Object)response);
            Date date = SimpleDateThreadLocalAsyncServlet.parseDate(response);
            Assert.assertTrue((String)"Date thread-local is not in range", (date.compareTo(start) >= 0 && date.compareTo(new Date()) <= 0 ? 1 : 0) != 0);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDispatchAttributes() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?n1=v1&n2=v2");
            get.setHeader("dispatch", "/pathinfo");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"wrapped: pathInfo:null queryString:n1=v1&n2=v2 servletPath:/pathinfo requestUri:/servletContext/pathinfo\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.request_uri:/servletContext/dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.context_path:/servletContext\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.servlet_path:/dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.path_info:null\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.query_string:n1=v1&n2=v2\r\n"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDispatchAttributesEncoded() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch/dis%25patch?n1=v%251&n2=v2");
            get.setHeader("dispatch", "/pathinfo/path%25info?n3=v%253");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"wrapped: pathInfo:/path%info queryString:n3=v%253 servletPath:/pathinfo requestUri:/servletContext/pathinfo/path%25info\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.request_uri:/servletContext/dispatch/dis%25patch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.context_path:/servletContext\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.servlet_path:/dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.path_info:/dis%patch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.query_string:n1=v%251&n2=v2\r\n"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDispatchAttributesEncodedExtension() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dis%25patch.dispatch?n1=v%251&n2=v2");
            get.setHeader("dispatch", "/path%25info.info?n3=v%253");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"wrapped: pathInfo:null queryString:n3=v%253 servletPath:/path%info.info requestUri:/servletContext/path%25info.info\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.request_uri:/servletContext/dis%25patch.dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.context_path:/servletContext\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.servlet_path:/dis%patch.dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.path_info:null\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"javax.servlet.async.query_string:n1=v%251&n2=v2\r\n"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDispatchParametersAreMerged() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?param1=v11&param1=v12");
            get.setHeader("dispatch", "/echo-parameters?param1=v13&param1=v14");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"wrapped: param1='v13,v14,v11,v12'", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static class SimpleDateThreadSetupHandler
    implements ThreadSetupHandler {
        private SimpleDateThreadSetupHandler() {
        }

        public <T, C> ThreadSetupHandler.Action<T, C> create(ThreadSetupHandler.Action<T, C> action) {
            return (exchange, context) -> {
                SimpleDateThreadLocalAsyncServlet.initThreadLocalSimpleDate();
                try {
                    Object object = action.call(exchange, context);
                    return object;
                }
                finally {
                    SimpleDateThreadLocalAsyncServlet.removeThreadLocalSimpleDate();
                }
            };
        }
    }
}

