/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.session.SessionServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class CrossContextServletBrokenSessionFactoryTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        ServletContainer container = ServletContainer.Factory.newInstance();
        PathHandler path = new PathHandler();
        DefaultServer.setRootHandler((HttpHandler)path);
        InMemorySessionManager manager = new InMemorySessionManager("test");
        CrossContextServletBrokenSessionFactoryTestCase.createDeployment("1", container, path, manager);
        CrossContextServletBrokenSessionFactoryTestCase.createDeployment("2", container, path, manager);
    }

    private static void createDeployment(final String name, ServletContainer container, PathHandler path, final InMemorySessionManager sessionManager) throws ServletException {
        ServletInfo s = new ServletInfo("servlet", SessionServlet.class).addMapping("/servlet");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/" + name).setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName(name + ".war").setSessionManagerFactory(new SessionManagerFactory(){

            public SessionManager createSessionManager(Deployment deployment) {
                return "1".equals(name) ? sessionManager : null;
            }
        }).setDefaultSessionTimeout(1).setServletSessionConfig(new ServletSessionConfig().setPath("/")).addServlets(new ServletInfo[]{s});
        try {
            DeploymentManager manager = container.addDeployment(builder);
            manager.deploy();
            path.addPrefixPath(builder.getContextPath(), manager.start());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedSessionCookieMultipleDeployments() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet direct1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/servlet");
            CloseableHttpResponse result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"1", (Object)response);
            result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"2", (Object)response);
            Thread.sleep(1000L);
            result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"1", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

