/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EarlyCloseClientServlet
extends HttpServlet {
    private static volatile boolean exceptionThrown;
    private static volatile boolean completedNormally;
    private static volatile CountDownLatch latch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ServletInputStream inputStream = req.getInputStream();
            byte[] buf = new byte[1024];
            while ((read = inputStream.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            resp.getOutputStream().write(out.toByteArray());
            completedNormally = true;
        }
        catch (IOException e) {
            exceptionThrown = true;
        }
        finally {
            latch.countDown();
        }
    }

    public static void reset() {
        latch = new CountDownLatch(1);
        completedNormally = false;
        exceptionThrown = false;
    }

    public static boolean isExceptionThrown() {
        return exceptionThrown;
    }

    public static boolean isCompletedNormally() {
        return completedNormally;
    }

    public static CountDownLatch getLatch() {
        return latch;
    }

    static {
        latch = new CountDownLatch(1);
    }
}

