/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletOutputStreamClosureTestCase {
    @Test
    public void testFlushAfterContentLengthReached() throws IOException {
        final AtomicReference thrown = new AtomicReference();
        DeploymentUtils.setupServlet(new ServletInfo("servlet", HttpServlet.class, (InstanceFactory)new ImmediateInstanceFactory((Object)new HttpServlet(){

            protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                resp.setHeader("Content-Length", "1");
                try {
                    ServletOutputStream out = resp.getOutputStream();
                    out.write(65);
                    out.flush();
                    out.close();
                }
                catch (Throwable t) {
                    thrown.set(t);
                    throw t;
                }
            }
        })).addMapping("/*"));
        ServletOutputStreamClosureTestCase.makeSuccessfulRequest("A");
        Throwable maybeFailure = (Throwable)thrown.get();
        if (maybeFailure != null) {
            throw new AssertionError("Unexpected failure", maybeFailure);
        }
    }

    @Test
    public void testFlushAfterClose() throws IOException {
        final AtomicReference thrown = new AtomicReference();
        DeploymentUtils.setupServlet(new ServletInfo("servlet", HttpServlet.class, (InstanceFactory)new ImmediateInstanceFactory((Object)new HttpServlet(){

            protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    ServletOutputStream out = resp.getOutputStream();
                    out.write(65);
                    out.close();
                    out.flush();
                }
                catch (Throwable t) {
                    thrown.set(t);
                    throw t;
                }
            }
        })).addMapping("/*"));
        ServletOutputStreamClosureTestCase.makeSuccessfulRequest("A");
        Throwable maybeFailure = (Throwable)thrown.get();
        if (maybeFailure != null) {
            throw new AssertionError("Unexpected failure", maybeFailure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeSuccessfulRequest(String expectedContent) throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)expectedContent, (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

