/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.dispatchingfilter;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.dispatchingfilter.DispatchingFilter;
import io.undertow.servlet.test.path.ServletPathMappingTestCase;
import io.undertow.servlet.test.util.PathTestServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.FutureResult;

@RunWith(value=DefaultServer.class)
public class DispatchingFilterTestCase {
    static FutureResult<Boolean> readyToStop = new FutureResult();
    private static DeploymentManager manager;

    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ServletPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war");
        builder.addServlet(new ServletInfo("DefaultTestServlet", PathTestServlet.class).addMapping("/path/default"));
        builder.addFilter(new FilterInfo("dispatching-filter", DispatchingFilter.class));
        builder.addFilterUrlMapping("dispatching-filter", "/*", DispatcherType.REQUEST);
        builder.addFilterUrlMapping("dispatching-filter", "/*", DispatcherType.FORWARD);
        manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @Test
    public void test() throws InterruptedException, ServletException, IOException {
        FutureResult responseFuture = new FutureResult();
        new Thread(() -> {
            TestHttpClient client = new TestHttpClient();
            try {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path/default");
                responseFuture.setResult((Object)client.execute((HttpUriRequest)get));
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                responseFuture.setException(e);
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }).start();
        readyToStop.getIoFuture().await();
        manager.stop();
        HttpResponse result = (HttpResponse)responseFuture.getIoFuture().get();
        int statusCode = result.getStatusLine().getStatusCode();
        Assert.assertTrue((statusCode == 500 || statusCode == 404 ? 1 : 0) != 0);
    }
}

