/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.response.writer;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.test.response.writer.AsyncExceptionWriterServlet;
import io.undertow.servlet.test.response.writer.AsyncLargeResponseWriterServlet;
import io.undertow.servlet.test.response.writer.AsyncResponseWriterOnPostServlet;
import io.undertow.servlet.test.response.writer.AsyncResponseWriterServlet;
import io.undertow.servlet.test.response.writer.ExceptionWriterServlet;
import io.undertow.servlet.test.response.writer.LargeResponseWriterServlet;
import io.undertow.servlet.test.response.writer.ResponseWriterOnPostServlet;
import io.undertow.servlet.test.response.writer.ResponseWriterServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ResponseWriterTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ResponseWriterTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").addServlet(Servlets.servlet((String)"resp", ResponseWriterServlet.class).addMapping("/resp")).addServlet(Servlets.servlet((String)"respLarge", LargeResponseWriterServlet.class).addMapping("/large")).addServlet(Servlets.servlet((String)"exception", ExceptionWriterServlet.class).addMapping("/exception")).addServlet(Servlets.servlet((String)"respBeforeRead", ResponseWriterOnPostServlet.class).addMapping("/resp-before-read")).addServlet(Servlets.servlet((String)"asyncResp", AsyncResponseWriterServlet.class).setAsyncSupported(true).addMapping("/async-resp")).addServlet(Servlets.servlet((String)"asyncRespLarge", AsyncLargeResponseWriterServlet.class).setAsyncSupported(true).addMapping("/async-large")).addServlet(Servlets.servlet((String)"asyncException", AsyncExceptionWriterServlet.class).setAsyncSupported(true).addMapping("/async-exception")).addServlet(Servlets.servlet((String)"asyncRespBeforeRead", AsyncResponseWriterOnPostServlet.class).setAsyncSupported(true).addMapping("/async-resp-before-read"));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @Test
    public void testContentLengthBasedFlush() throws Exception {
        this.assertContentLengthBasedFlush("resp");
    }

    @Test
    public void testAsyncContentLengthBasedFlush() throws Exception {
        this.assertContentLengthBasedFlush("async-resp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertContentLengthBasedFlush(String path) throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/" + path + "?test=" + "content-length-flush");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String data = FileUtils.readFile((InputStream)result.getEntity().getContent());
            Assert.assertEquals((Object)"first-aaaa", (Object)data);
            Assert.assertEquals((long)0L, (long)result.getHeaders("not-header").length);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testWriterLargeResponse() throws Exception {
        this.assertWriterLargeResponse("large");
    }

    @Test
    public void testAsyncWriterLargeResponse() throws Exception {
        this.assertWriterLargeResponse("async-large");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertWriterLargeResponse(String path) throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/" + path);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String data = FileUtils.readFile((InputStream)result.getEntity().getContent());
            Assert.assertEquals((Object)LargeResponseWriterServlet.getMessage(), (Object)data);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testExceptionResponse() throws Exception {
        this.assertExceptionResponse("exception");
    }

    @Test
    public void testAsyncExceptionResponse() throws Exception {
        this.assertExceptionResponse("async-exception");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertExceptionResponse(String path) throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/" + path);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = FileUtils.readFile((InputStream)result.getEntity().getContent());
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.startsWith((String)"java.lang.Exception: TestException"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testRespondBeforeRead() throws Throwable {
        this.assertRespondBeforeRead("resp-before-read");
    }

    @Test
    public void testAsyncRespondBeforeRead() throws Throwable {
        this.assertRespondBeforeRead("async-resp-before-read");
    }

    private void assertRespondBeforeRead(String path) throws Throwable {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("Connection", "close"));
        HttpClientBuilder builder = HttpClients.custom().setDefaultHeaders(headers).setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        try (CloseableHttpClient client = builder.build();){
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/" + path + "?test=" + "content-length-flush");
            Path rootPath = Paths.get(this.getClass().getResource(this.getClass().getSimpleName() + ".class").toURI());
            SlowInputStream inputStream = new SlowInputStream(new BufferedInputStream(new FileInputStream(rootPath.toFile())));
            post.setEntity((HttpEntity)new InputStreamEntity((InputStream)inputStream));
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            boolean fullyRead = inputStream.waitTillIsFullyRead();
            Throwable exception = ResponseWriterOnPostServlet.getExceptionIfAny();
            if (exception != null) {
                throw exception;
            }
            org.wildfly.common.Assert.assertTrue((boolean)fullyRead);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String data = FileUtils.readFile((InputStream)result.getEntity().getContent());
            Assert.assertEquals((Object)"first-aaaa", (Object)data);
            Assert.assertEquals((long)0L, (long)result.getHeaders("not-header").length);
        }
    }

    private static class SlowInputStream
    extends InputStream {
        private final InputStream innerInputStream;
        final CountDownLatch latch = new CountDownLatch(1);

        SlowInputStream(InputStream innerInputStream) {
            this.innerInputStream = innerInputStream;
        }

        @Override
        public int read() throws IOException {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int readByte = this.innerInputStream.read();
            if (readByte == -1) {
                this.latch.countDown();
            }
            return readByte;
        }

        boolean waitTillIsFullyRead() throws InterruptedException {
            boolean fullyRead = this.latch.await(60L, TimeUnit.SECONDS);
            Thread.sleep(50L);
            return fullyRead;
        }
    }
}

