/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.metrics;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.MetricsHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.MetricsCollector;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.defaultservlet.DefaultServletTestCase;
import io.undertow.servlet.test.defaultservlet.HelloFilter;
import io.undertow.servlet.test.metrics.MetricTestServlet;
import io.undertow.servlet.test.metrics.TestMetricsCollector;
import io.undertow.servlet.test.path.ServletPathMappingTestCase;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.CompletionLatchHandler;
import javax.servlet.DispatcherType;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletMetricsHandlerTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetrics() throws Exception {
        TestMetricsCollector metricsCollector = new TestMetricsCollector();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ServletPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new TestResourceLoader(DefaultServletTestCase.class));
        builder.addServlet(new ServletInfo("MetricTestServlet", MetricTestServlet.class).addMapping("/path/default"));
        builder.addFilter(new FilterInfo("Filter", HelloFilter.class));
        builder.addFilterUrlMapping("Filter", "/filterpath/*", DispatcherType.REQUEST);
        builder.setMetricsCollector((MetricsCollector)metricsCollector);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        CompletionLatchHandler completionLatchHandler = new CompletionLatchHandler((HttpHandler)root);
        DefaultServer.setRootHandler((HttpHandler)completionLatchHandler);
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path/default");
        TestHttpClient client = new TestHttpClient();
        try {
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)HttpClientUtils.readResponse((HttpResponse)result).contains("metric"));
            completionLatchHandler.await();
            completionLatchHandler.reset();
            MetricsHandler.MetricResult metrics = metricsCollector.getMetrics("MetricTestServlet");
            Assert.assertEquals((long)1L, (long)metrics.getTotalRequests());
            Assert.assertTrue((metrics.getMaxRequestTime() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)metrics.getMinRequestTime(), (long)metrics.getMaxRequestTime());
            Assert.assertEquals((long)metrics.getMaxRequestTime(), (long)metrics.getTotalRequestTime());
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)HttpClientUtils.readResponse((HttpResponse)result).contains("metric"));
            completionLatchHandler.await();
            completionLatchHandler.reset();
            metrics = metricsCollector.getMetrics("MetricTestServlet");
            Assert.assertEquals((long)2L, (long)metrics.getTotalRequests());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

