/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EagerAsyncInputStreamServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.startAsync();
        MyListener listener = new MyListener(resp.getOutputStream(), req.getInputStream(), new ByteArrayOutputStream(), req.getAsyncContext());
        resp.getOutputStream().setWriteListener((WriteListener)listener);
        req.getInputStream().setReadListener((ReadListener)listener);
        req.getInputStream().isReady();
    }

    private class MyListener
    implements WriteListener,
    ReadListener {
        private final ServletOutputStream outputStream;
        private final ServletInputStream inputStream;
        private final ByteArrayOutputStream dataToWrite;
        private final AsyncContext context;
        boolean done = false;
        int written = 0;

        MyListener(ServletOutputStream outputStream, ServletInputStream inputStream, ByteArrayOutputStream dataToWrite, AsyncContext context) {
            this.outputStream = outputStream;
            this.inputStream = inputStream;
            this.dataToWrite = dataToWrite;
            this.context = context;
        }

        public void onWritePossible() throws IOException {
            if (this.outputStream.isReady()) {
                this.dataToWrite.writeTo((OutputStream)this.outputStream);
                this.written += this.dataToWrite.size();
                this.dataToWrite.reset();
                if (this.done) {
                    this.context.complete();
                }
            }
        }

        public void onDataAvailable() throws IOException {
            this.doOnDataAvailable();
        }

        private void doOnDataAvailable() {
            try {
                while (this.inputStream.isReady()) {
                    int read = this.inputStream.read();
                    if (read == 0) {
                        System.out.println("onDataAvailable> read 0x00");
                    }
                    if (read != -1) {
                        this.dataToWrite.write(read);
                        continue;
                    }
                    this.onWritePossible();
                }
            }
            catch (IOException e) {
                this.context.complete();
                throw new RuntimeException(e);
            }
        }

        public synchronized void onAllDataRead() throws IOException {
            this.done = true;
            this.onWritePossible();
        }

        public synchronized void onError(Throwable t) {
            t.printStackTrace();
        }
    }
}

