/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.multipart.forward;

import io.undertow.servlet.Servlets;
import io.undertow.servlet.test.multipart.forward.ForwardingServlet;
import io.undertow.servlet.test.multipart.forward.MultiPartCapableServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class MultiPartForwardTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(Servlets.servlet((String)"MultiPartCapableServlet", MultiPartCapableServlet.class).addMapping("/multipart").setMultipartConfig(Servlets.multipartConfig(null, (long)0L, (long)0L, (int)0)), Servlets.servlet((String)"ForwardingServlet", ForwardingServlet.class).addMapping("/forward"));
    }

    @Test
    public void urlEncodedFormRequestDirectlyToMultipartServlet() throws IOException {
        String response = this.sendRequest("/multipart", (HttpEntity)this.createUrlEncodedFormPostEntity());
        Assert.assertEquals((Object)"Params:\r\nfoo: bar", (Object)response);
    }

    @Test
    public void urlEncodedFormRequestForwardedToMultipartServlet() throws IOException {
        String response = this.sendRequest("/forward", (HttpEntity)this.createUrlEncodedFormPostEntity());
        Assert.assertEquals((Object)"Params:\r\nfoo: bar", (Object)response);
    }

    @Test
    public void multiPartFormRequestDirectlyToMultipartServlet() throws IOException {
        String response = this.sendRequest("/multipart", (HttpEntity)this.createMultiPartFormPostEntity());
        Assert.assertEquals((Object)"Params:\r\nfoo: bar", (Object)response);
    }

    @Test
    public void multiPartFormRequestForwardedToMultipartServlet() throws IOException {
        String response = this.sendRequest("/forward", (HttpEntity)this.createMultiPartFormPostEntity());
        Assert.assertEquals((Object)"Params:\r\nfoo: bar", (Object)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendRequest(String path, HttpEntity postEntity) throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String uri = DefaultServer.getDefaultServerURL() + "/servletContext" + path;
            HttpPost post = new HttpPost(uri);
            post.setEntity(postEntity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String string = HttpClientUtils.readResponse((HttpResponse)result).trim();
            return string;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private MultipartEntity createMultiPartFormPostEntity() throws IOException {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        entity.addPart("foo", (ContentBody)new StringBody("bar"));
        return entity;
    }

    private UrlEncodedFormEntity createUrlEncodedFormPostEntity() throws IOException {
        BasicNameValuePair nameValuePair = new BasicNameValuePair("foo", "bar");
        return new UrlEncodedFormEntity(Arrays.asList(nameValuePair));
    }
}

