/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.proprietry;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.proprietry.IgnoresRequestAndSetsAttributeAsyncServlet;
import io.undertow.servlet.test.proprietry.IgnoresRequestAndSetsAttributeServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ExchangeCompletionTestCase {
    private static final String AN_ATTRIBUTE = "an.attribute";
    private static final String A_VALUE = "a.value";
    private static final BlockingQueue<String> completedExchangeAttributes = new LinkedBlockingQueue<String>();

    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlet(new ServletInfo("servlet", IgnoresRequestAndSetsAttributeServlet.class).addMapping("/sync").addInitParam("attributeKey", AN_ATTRIBUTE).addInitParam("attributeValue", A_VALUE)).addServlet(new ServletInfo("asyncservlet", IgnoresRequestAndSetsAttributeAsyncServlet.class).addMapping("/async").addInitParam("attributeKey", AN_ATTRIBUTE).addInitParam("attributeValue", A_VALUE).setAsyncSupported(true)).addInitialHandlerChainWrapper(new HandlerWrapper(){

            public HttpHandler wrap(final HttpHandler handler) {
                return new HttpHandler(){

                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                                Object result;
                                ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                                if (context != null && (result = context.getServletRequest().getAttribute(ExchangeCompletionTestCase.AN_ATTRIBUTE)) instanceof String) {
                                    completedExchangeAttributes.add((String)result);
                                }
                                nextListener.proceed();
                            }
                        });
                        handler.handleRequest(exchange);
                    }
                };
            }
        });
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @Before
    public void clearLoggedAttributes() {
        completedExchangeAttributes.clear();
    }

    @Test
    public void exchangeCompletionListenersSeeRequestAttributesEvenIfRequestBodyIsNotRead() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/sync");
            post.setEntity((HttpEntity)new StringEntity("some body that isn't read"));
            client.execute((HttpUriRequest)post);
            Assert.assertEquals((Object)A_VALUE, (Object)completedExchangeAttributes.poll(1L, TimeUnit.SECONDS));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void exchangeCompletionListenersSeeRequestAttributesEvenIfRequestBodyIsNotReadAsync() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/async");
            post.setEntity((HttpEntity)new StringEntity("some body that isn't read"));
            client.execute((HttpUriRequest)post);
            Assert.assertEquals((Object)A_VALUE, (Object)completedExchangeAttributes.poll(1L, TimeUnit.SECONDS));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

