/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.custom;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.handlers.security.ServletFormAuthenticationMechanism;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

public class CustomEncodingAuthenticationMechanism
extends ServletFormAuthenticationMechanism {
    public static final Factory FACTORY = new Factory();
    public String charset = null;

    public CustomEncodingAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage) {
        super(formParserFactory, name, loginPage, errorPage);
        this.charset = this.getcharset(formParserFactory);
    }

    public String getcharset(FormParserFactory formParserFactory) {
        FormParserFactory.ParserDefinition parserDefinition = null;
        FormParserFactory.ParserDefinition[] parserDefinitions = (FormParserFactory.ParserDefinition[])this.getPrivateField(formParserFactory, "parserDefinitions");
        if (parserDefinitions != null && (parserDefinition = parserDefinitions[0]) instanceof FormEncodedDataDefinition) {
            FormEncodedDataDefinition formEncodedDataDefinition = (FormEncodedDataDefinition)parserDefinition;
            return (String)this.getPrivateField(formEncodedDataDefinition, "defaultEncoding");
        }
        return null;
    }

    private Object getPrivateField(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            if (Modifier.isPrivate(field.getModifiers())) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final class Factory
    implements AuthenticationMechanismFactory {
        public AuthenticationMechanism create(String mechanismName, IdentityManager identityManager, FormParserFactory formParserFactory, Map<String, String> properties) {
            return new CustomEncodingAuthenticationMechanism(formParserFactory, mechanismName, properties.get("login_page"), properties.get("error_page"));
        }
    }
}

