/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.ssl;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.ssl.SSLAttributesServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SSLMetaDataTestCase {
    protected static PathHandler setupPathHandler() throws Exception {
        DefaultServer.startSSLServer();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", SSLAttributesServlet.class).addMapping("/id").addMapping("/cert").addMapping("/cert-dn").addMapping("/key-size").addMapping("/cipher-suite");
        DeploymentInfo info = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlet(s);
        DeploymentManager manager = container.addDeployment(info);
        manager.deploy();
        root.addPrefixPath(info.getContextPath(), manager.start());
        return root;
    }

    @BeforeClass
    public static void setup() throws Exception {
        PathHandler root = SSLMetaDataTestCase.setupPathHandler();
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        DefaultServer.stopSSLServer();
    }

    @Test
    public void testSessionId() throws IOException {
        String sessionId = this.internalTest("/id", new Header[0]);
        Assert.assertTrue((String)"The session-id is an HEX byte array", (sessionId.length() % 2 == 0 ? 1 : 0) != 0);
        for (int i = 0; i < sessionId.length(); ++i) {
            Character c = Character.valueOf(sessionId.charAt(i));
            Assert.assertTrue((String)"The session-id is an HEX byte array", (c.charValue() >= '0' && c.charValue() <= '9' || c.charValue() >= 'a' && c.charValue() <= 'f' ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCipherSuite() throws IOException {
        this.internalTest("/cipher-suite", new Header[0]);
    }

    @Test
    public void testKeySize() throws IOException {
        this.internalTest("/key-size", new Header[0]);
    }

    @Test
    public void testCert() throws IOException {
        this.internalTest("/cert", new Header[0]);
    }

    @Test
    public void testCertDn() throws IOException {
        String response = this.internalTest("/cert-dn", new Header[0]);
        Assert.assertEquals((Object)"CN=Test Client, OU=OU, O=Org, L=City, ST=State, C=GB", (Object)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String internalTest(String path, Header ... headers) throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        String url = DefaultServer.getDefaultServerSSLAddress() + "/servletContext" + path;
        try {
            HttpGet get = new HttpGet(url);
            get.setHeaders(headers);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((response.length() > 0 ? 1 : 0) != 0);
            String string = response;
            return string;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

