/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.session.SessionCookieConfigListener;
import io.undertow.servlet.test.session.SessionServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletSessionTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler pathHandler = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addListener(new ListenerInfo(SessionCookieConfigListener.class)).addServlets(new ServletInfo[]{new ServletInfo("servlet", SessionServlet.class).addMapping("/aa/b")});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        try {
            pathHandler.addPrefixPath(builder.getContextPath(), manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        DefaultServer.setRootHandler((HttpHandler)pathHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleSessionUsage() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aa/b");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"1", (Object)response);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"2", (Object)response);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"3", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionCookieConfig() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aa/b");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"1", (Object)response);
            String cookieValue = result.getHeaders("Set-Cookie")[0].getValue();
            Assert.assertTrue((boolean)cookieValue.contains("MySessionCookie"));
            Assert.assertTrue((boolean)cookieValue.contains("/servletContext/aa/"));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"2", (Object)response);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"3", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionConfigNoCookies() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore(new CookieStore(){

            public void addCookie(Cookie cookie) {
            }

            public List<Cookie> getCookies() {
                return Collections.EMPTY_LIST;
            }

            public boolean clearExpired(Date date) {
                return false;
            }

            public void clear() {
            }
        });
        try {
            CloseableHttpResponse result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aa/b;foo=bar"));
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"1", (Object)response);
            String url = result.getHeaders("url")[0].getValue();
            result = client.execute((HttpUriRequest)new HttpGet(url));
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            url = result.getHeaders("url")[0].getValue();
            Assert.assertEquals((Object)"2", (Object)response);
            result = client.execute((HttpUriRequest)new HttpGet(url));
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"3", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionConfigNoCookiesMatrixParameters() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore(new CookieStore(){

            public void addCookie(Cookie cookie) {
            }

            public List<Cookie> getCookies() {
                return Collections.EMPTY_LIST;
            }

            public boolean clearExpired(Date date) {
                return false;
            }

            public void clear() {
            }
        });
        try {
            CloseableHttpResponse result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + ";foo=bar/servletContext/aa/b"));
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"1", (Object)response);
            String url = result.getHeaders("url")[0].getValue();
            result = client.execute((HttpUriRequest)new HttpGet(url));
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            url = result.getHeaders("url")[0].getValue();
            Assert.assertEquals((Object)"2", (Object)response);
            result = client.execute((HttpUriRequest)new HttpGet(url));
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"3", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

