/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractServletInputStreamTestCase {
    public static final String HELLO_WORLD = "Hello World";
    public static final String BLOCKING_SERVLET = "blockingInput";
    public static final String ASYNC_SERVLET = "asyncInput";
    public static final String ASYNC_EAGER_SERVLET = "asyncEagerInput";

    @Test
    public void testBlockingServletInputStream() {
        StringBuilder builder = new StringBuilder(1000 * HELLO_WORLD.length());
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 1000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString();
                this.runTest(message, BLOCKING_SERVLET, false, false);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Test
    public void testAsyncServletInputStream() {
        StringBuilder builder = new StringBuilder(1000 * HELLO_WORLD.length());
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 10000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString();
                this.runTest(message, ASYNC_SERVLET, false, false);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Test
    public void testAsyncServletInputStreamWithPreamble() {
        StringBuilder builder = new StringBuilder(2000 * HELLO_WORLD.length());
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 10000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString();
                this.runTest(message, ASYNC_SERVLET, true, false);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Test
    public void testAsyncServletInputStreamInParallel() throws Exception {
        StringBuilder builder = new StringBuilder(100000 * HELLO_WORLD.length());
        for (int j = 0; j < 100000; ++j) {
            builder.append(HELLO_WORLD);
        }
        String message = builder.toString();
        this.runTestParallel(20, message, ASYNC_SERVLET, false, false);
    }

    @Test
    public void testAsyncServletInputStreamInParallelOffIoThread() throws Exception {
        StringBuilder builder = new StringBuilder(100000 * HELLO_WORLD.length());
        for (int j = 0; j < 100000; ++j) {
            builder.append(HELLO_WORLD);
        }
        String message = builder.toString();
        this.runTestParallel(20, message, ASYNC_SERVLET, false, true);
    }

    @Test
    public void testAsyncServletInputStreamOffIoThread() {
        StringBuilder builder = new StringBuilder(2000 * HELLO_WORLD.length());
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 10000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString();
                this.runTest(message, ASYNC_SERVLET, false, true);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Test
    public void testAsyncServletInputStreamOffIoThreadWithPreamble() {
        StringBuilder builder = new StringBuilder(2000 * HELLO_WORLD.length());
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 10000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString();
                this.runTest(message, ASYNC_SERVLET, true, true);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Test
    public void testAsyncServletInputStreamWithEmptyRequestBody() {
        String message = "";
        try {
            this.runTest(message, ASYNC_SERVLET, false, false);
        }
        catch (Throwable e) {
            throw new RuntimeException("test failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestViaJavaImpl(String message, String url) throws IOException {
        HttpURLConnection urlcon = null;
        try {
            int len;
            String uri = this.getBaseUrl() + "/servletContext/" + url;
            urlcon = (HttpURLConnection)new URL(uri).openConnection();
            urlcon.setInstanceFollowRedirects(true);
            urlcon.setRequestProperty("Connection", "close");
            urlcon.setRequestMethod("POST");
            urlcon.setDoInput(true);
            urlcon.setDoOutput(true);
            OutputStream os = urlcon.getOutputStream();
            os.write(message.getBytes());
            os.close();
            Assert.assertEquals((long)200L, (long)urlcon.getResponseCode());
            InputStream is = urlcon.getInputStream();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((len = is.read(buf)) > 0) {
                bytes.write(buf, 0, len);
            }
            is.close();
            String response = new String(bytes.toByteArray(), 0, bytes.size());
            if (!message.equals(response)) {
                System.out.println(String.format("response=%s", Hex.encodeHexString((byte[])response.getBytes())));
            }
            Assert.assertEquals((Object)message, (Object)response);
        }
        finally {
            if (urlcon != null) {
                urlcon.disconnect();
            }
        }
    }

    protected String getBaseUrl() {
        return DefaultServer.getDefaultServerURL();
    }

    @Test
    public void testAsyncServletInputStream3() {
        String message = "to_user_id=7999&msg_body=msg3";
        for (int i = 0; i < 200; ++i) {
            try {
                this.runTestViaJavaImpl(message, ASYNC_SERVLET);
                continue;
            }
            catch (Throwable e) {
                System.out.println("test failed with i equal to " + i);
                e.printStackTrace();
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String message, String url, boolean preamble, boolean offIOThread) throws IOException {
        TestHttpClient client = this.createClient();
        try {
            String uri = this.getBaseUrl() + "/servletContext/" + url;
            HttpPost post = new HttpPost(uri);
            if (preamble && !message.isEmpty()) {
                post.addHeader("preamble", Integer.toString(message.length() / 2));
            }
            if (offIOThread) {
                post.addHeader("offIoThread", "true");
            }
            post.setEntity((HttpEntity)new StringEntity(message));
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((long)message.length(), (long)response.length());
            Assert.assertEquals((Object)message, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestParallel(int concurrency, final String message, final String url, final boolean preamble, final boolean offIOThread) throws Exception {
        final byte[] messageBytes = message.getBytes();
        try (final CloseableHttpClient client = HttpClients.custom().setMaxConnPerRoute(1000).setSSLContext(DefaultServer.createClientSslContext()).build();){
            ExecutorService executorService = Executors.newFixedThreadPool(concurrency);
            Callable<Void> task = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    String uri = AbstractServletInputStreamTestCase.this.getBaseUrl() + "/servletContext/" + url;
                    HttpPost post = new HttpPost(uri);
                    if (preamble && !message.isEmpty()) {
                        post.addHeader("preamble", Integer.toString(message.length() / 2));
                    }
                    if (offIOThread) {
                        post.addHeader("offIoThread", "true");
                    }
                    post.setEntity((HttpEntity)new InputStreamEntity((InputStream)new RateLimitedInputStream(new ByteArrayInputStream(messageBytes))));
                    try (CloseableHttpResponse result = client.execute((HttpUriRequest)post);){
                        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                        String response = HttpClientUtils.readResponse((HttpResponse)result);
                        Assert.assertEquals((long)message.length(), (long)response.length());
                        Assert.assertEquals((Object)message, (Object)response);
                    }
                    return null;
                }
            };
            ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
            for (int i = 0; i < concurrency * 5; ++i) {
                Future<Void> future = executorService.submit(task);
                results.add(future);
            }
            for (Future future : results) {
                future.get();
            }
            executorService.shutdown();
            Assert.assertTrue((boolean)executorService.awaitTermination(70L, TimeUnit.SECONDS));
        }
    }

    protected TestHttpClient createClient() {
        return new TestHttpClient();
    }

    private static final class RateLimitedInputStream
    extends InputStream {
        private final InputStream in;
        private int count;

        RateLimitedInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            if (this.count++ % 1000 == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
            return this.in.read();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }
}

