/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.defaultservlet;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.path.ServletPathMappingTestCase;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.util.PathTestServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class WelcomeFileSecurityTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "role1");
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ServletPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new TestResourceLoader(WelcomeFileSecurityTestCase.class)).addWelcomePages(new String[]{"doesnotexist.html", "index.html", "default"}).setIdentityManager((IdentityManager)identityManager).setLoginConfig(new LoginConfig("BASIC", "Test Realm")).addServlet(new ServletInfo("DefaultTestServlet", PathTestServlet.class).setServletSecurityInfo((ServletSecurityInfo)new ServletSecurityInfo().addRoleAllowed("role1")).addMapping("/path/default")).addSecurityConstraint(((SecurityConstraint)new SecurityConstraint().addRoleAllowed("role1")).addWebResourceCollection(new WebResourceCollection().addUrlPattern("/index.html")));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWelcomeFileRedirect() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
            Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)values[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/");
            get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"user1:password1".getBytes(), (boolean)false));
            result = client.execute((HttpUriRequest)get);
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)response.contains("Redirected home page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWelcomeServletRedirect() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path?a=b");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
            Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)values[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path?a=b");
            get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"user1:password1".getBytes(), (boolean)false));
            result = client.execute((HttpUriRequest)get);
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"pathInfo:null queryString:a=b servletPath:/path/default requestUri:/servletContext/path/", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

