/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.defaultservlet;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.test.defaultservlet.GetDateFilter;
import io.undertow.servlet.test.defaultservlet.HelloFilter;
import io.undertow.servlet.test.path.ServletPathMappingTestCase;
import io.undertow.servlet.test.util.PathTestServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.DateUtils;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DefaultServletTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ServletPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new TestResourceLoader(DefaultServletTestCase.class));
        builder.addServlet(new ServletInfo("DefaultTestServlet", PathTestServlet.class).addMapping("/path/default"));
        builder.addServlet(new ServletInfo("default", DefaultServlet.class).addInitParam("directory-listing", "true").addMapping("/*"));
        builder.addFilter(new FilterInfo("date-header", GetDateFilter.class));
        builder.addFilterUrlMapping("date-header", "/*", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("Filter", HelloFilter.class));
        builder.addFilterUrlMapping("Filter", "/filterpath/*", DispatcherType.REQUEST);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleResource() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/index.html");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.contains("Redirected home page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeRequest() throws IOException, InterruptedException {
        String uri = DefaultServer.getDefaultServerURL() + "/servletContext/range.txt";
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/index.html");
            get.addHeader("Range", "bytes=2-3");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"--", (Object)response);
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=3-100");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"3456789", (Object)response);
            Assert.assertEquals((Object)"bytes 3-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=3-9");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"3456789", (Object)response);
            Assert.assertEquals((Object)"bytes 3-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=2-3");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"23", (Object)response);
            Assert.assertEquals((Object)"bytes 2-3/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=0-0");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"0", (Object)response);
            Assert.assertEquals((Object)"bytes 0-0/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=1-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"123456789", (Object)response);
            Assert.assertEquals((Object)"bytes 1-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=0-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"0123456789", (Object)response);
            Assert.assertEquals((Object)"bytes 0-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=9-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"9", (Object)response);
            Assert.assertEquals((Object)"bytes 9-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=-1");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"9", (Object)response);
            Assert.assertEquals((Object)"bytes 9-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=-100");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"0123456789", (Object)response);
            Assert.assertEquals((Object)"bytes 0-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=99-100");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)416L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"", (Object)response);
            Assert.assertEquals((Object)"bytes */10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=2-1");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)416L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"", (Object)response);
            Assert.assertEquals((Object)"bytes */10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=2-3");
            get.addHeader("If-Range", DateUtils.toDateString((Date)new Date(System.currentTimeMillis() + 1000L)));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"23", (Object)response);
            Assert.assertEquals((Object)"bytes 2-3/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(uri);
            get.addHeader("Range", "bytes=2-3");
            get.addHeader("If-Range", DateUtils.toDateString((Date)new Date(0L)));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"0123456789", (Object)response);
            Assert.assertNull((Object)result.getFirstHeader("Content-Range"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceWithFilter() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/filterpath/filtered.txt");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Hello Stuart", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowedResource() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/disallowed.sh");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoAccessToMetaInfResource() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/meta-inf/secret");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryListing() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Header contentType = result.getFirstHeader("Content-Type");
            Assert.assertNotNull((Object)contentType);
            Assert.assertTrue((boolean)contentType.getValue().contains("text/html"));
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIfMoodifiedSince() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/index.html");
            get.addHeader("date-header", "Fri, 10 Oct 2014 21:35:55 CEST");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.contains("Redirected home page"));
            String lm = result.getHeaders("Last-Modified")[0].getValue();
            System.out.println(lm);
            Assert.assertTrue((boolean)lm.endsWith("GMT"));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/index.html");
            get.addHeader("IF-Modified-Since", lm);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)304L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertFalse((boolean)response.contains("Redirected home page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

