/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.path;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.path.PathFilter;
import io.undertow.servlet.test.path.PathMappingServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FilterPathMappingTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicFilterMappings() throws IOException, ServletException {
        DeploymentInfo builder = new DeploymentInfo();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        builder.addServlet(new ServletInfo("/a/*", PathMappingServlet.class).addMapping("/a/*"));
        builder.addServlet(new ServletInfo("/aa", PathMappingServlet.class).addMapping("/aa"));
        builder.addServlet(new ServletInfo("/", PathMappingServlet.class).addMapping("/"));
        builder.addServlet(new ServletInfo("contextRoot", PathMappingServlet.class).addMapping(""));
        builder.addServlet(new ServletInfo("/myservlet/*", PathMappingServlet.class).addMapping("/myservlet/*"));
        builder.addServlet(new ServletInfo("*.jsp", PathMappingServlet.class).addMapping("*.jsp"));
        builder.addServlet(new ServletInfo("/hello/*", PathMappingServlet.class).addMapping("/hello/*"));
        builder.addServlet(new ServletInfo("/test/*", PathMappingServlet.class).addMapping("/test/*"));
        builder.addServlet(new ServletInfo("/test2", PathMappingServlet.class).addMapping("/test2"));
        builder.addFilter(new FilterInfo("/*", PathFilter.class));
        builder.addFilterUrlMapping("/*", "/*", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("*", PathFilter.class));
        builder.addFilterUrlMapping("*", "*", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("/a/*", PathFilter.class));
        builder.addFilterUrlMapping("/a/*", "/a/*", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("/aa", PathFilter.class));
        builder.addFilterUrlMapping("/aa", "/aa", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("*.bop", PathFilter.class));
        builder.addFilterUrlMapping("*.bop", "*.bop", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("/myservlet/myfilter/*", PathFilter.class));
        builder.addFilterUrlMapping("/myservlet/myfilter/*", "/myservlet/myfilter/*", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("/myfilter/*", PathFilter.class));
        builder.addFilterUrlMapping("/myfilter/*", "/myfilter/*", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("contextRoot", PathFilter.class));
        builder.addFilterServletNameMapping("contextRoot", "contextRoot", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("defaultName", PathFilter.class));
        builder.addFilterServletNameMapping("defaultName", "/", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("/helloworld/index.html", PathFilter.class));
        builder.addFilterUrlMapping("/helloworld/index.html", "/helloworld/index.html", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("/test", PathFilter.class));
        builder.addFilterUrlMapping("/test", "/test", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("/test2/*", PathFilter.class));
        builder.addFilterUrlMapping("/test2/*", "/test2/*", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("allByName", PathFilter.class));
        builder.addFilterServletNameMapping("allByName", "*", DispatcherType.REQUEST);
        builder.setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(FilterPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war");
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
        TestHttpClient client = new TestHttpClient();
        try {
            this.runTest(client, "test", "/test/* - /test - null", "/*", "*", "/test", "allByName");
            this.runTest(client, "test2", "/test2 - /test2 - null", "/*", "*", "/test2/*", "allByName");
            this.runTest(client, "aa", "/aa - /aa - null", "/*", "*", "/aa", "allByName");
            this.runTest(client, "a/c", "/a/* - /a - /c", "/*", "*", "/a/*", "allByName");
            this.runTest(client, "a", "/a/* - /a - null", "/*", "*", "/a/*", "allByName");
            this.runTest(client, "aa/b", "/ - /aa/b - null", "/*", "*", "defaultName", "allByName");
            this.runTest(client, "a/b/c/d", "/a/* - /a - /b/c/d", "/*", "*", "/a/*", "allByName");
            this.runTest(client, "defaultStuff", "/ - /defaultStuff - null", "/*", "*", "defaultName", "allByName");
            this.runTest(client, "", "contextRoot - / - null", "/*", "*", "contextRoot", "allByName");
            this.runTest(client, "yyyy.bop", "/ - /yyyy.bop - null", "/*", "*", "*.bop", "defaultName", "allByName");
            this.runTest(client, "a/yyyy.bop", "/a/* - /a - /yyyy.bop", "/*", "*", "*.bop", "/a/*", "allByName");
            this.runTest(client, "myservlet/myfilter/file.dat", "/myservlet/* - /myservlet - /myfilter/file.dat", "/*", "*", "/myservlet/myfilter/*", "allByName");
            this.runTest(client, "myservlet/myfilter/file.jsp", "/myservlet/* - /myservlet - /myfilter/file.jsp", "/*", "*", "/myservlet/myfilter/*", "allByName");
            this.runTest(client, "otherservlet/myfilter/file.jsp", "*.jsp - /otherservlet/myfilter/file.jsp - null", "/*", "*", "allByName");
            this.runTest(client, "myfilter/file.jsp", "*.jsp - /myfilter/file.jsp - null", "/*", "*", "/myfilter/*", "allByName");
            this.runTest(client, "helloworld/index.html", "/ - /helloworld/index.html - null", "/*", "*", "/helloworld/index.html", "defaultName", "allByName");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExtensionMatchServletWithGlobalFilter() throws IOException, ServletException {
        DeploymentInfo builder = new DeploymentInfo();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        builder.addServlet(new ServletInfo("*.jsp", PathMappingServlet.class).addMapping("*.jsp"));
        builder.addFilter(new FilterInfo("/*", PathFilter.class));
        builder.addFilterUrlMapping("/*", "/*", DispatcherType.REQUEST);
        builder.setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(FilterPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war");
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
        TestHttpClient client = new TestHttpClient();
        try {
            this.runTest(client, "aa.jsp", "*.jsp - /aa.jsp - null", "/*");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_WFLY_1935() throws IOException, ServletException {
        DeploymentInfo builder = new DeploymentInfo();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        builder.addServlet(new ServletInfo("*.a", PathMappingServlet.class).addMapping("*.a"));
        builder.addFilter(new FilterInfo("/*", PathFilter.class));
        builder.addFilterUrlMapping("/*", "/*", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("/SimpleServlet.a", PathFilter.class));
        builder.addFilterUrlMapping("/SimpleServlet.a", "/SimpleServlet.a", DispatcherType.REQUEST);
        builder.setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(FilterPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war");
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
        TestHttpClient client = new TestHttpClient();
        try {
            this.runTest(client, "SimpleServlet.a", "*.a - /SimpleServlet.a - null", "/*", "/SimpleServlet.a");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void runTest(TestHttpClient client, String path, String expected, String ... headers) throws IOException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/" + path);
        CloseableHttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        this.requireHeaders((HttpResponse)result, headers);
        String response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertEquals((Object)expected, (Object)response);
    }

    private void requireHeaders(HttpResponse result, String ... headers) {
        Header[] resultHeaders = result.getAllHeaders();
        ArrayList<Header> realResultHeaders = new ArrayList<Header>();
        for (Header header : resultHeaders) {
            if (!header.getName().startsWith("filter")) continue;
            realResultHeaders.add(header);
        }
        HashSet<String> found = new HashSet<String>(Arrays.asList(headers));
        for (Header header : realResultHeaders) {
            if (found.remove(header.getValue())) continue;
            Assert.fail((String)("Found unexpected header " + header.getValue()));
        }
        if (!found.isEmpty()) {
            Assert.fail((String)("header(s) not found " + found));
        }
    }
}

