/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.path;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.path.GetMappingServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.MappingMatch;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletSpecExampleTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletInfo("servlet1", GetMappingServlet.class).addMapping("/foo/bar/*"), new ServletInfo("servlet2", GetMappingServlet.class).addMapping("/baz/*"), new ServletInfo("servlet3", GetMappingServlet.class).addMapping("/catalog"), new ServletInfo("servlet4", GetMappingServlet.class).addMapping("*.bop"), new ServletInfo("default", GetMappingServlet.class));
    }

    @Test
    public void testOne() {
        ServletSpecExampleTestCase.doTest("/foo/bar/index.html", MappingMatch.PATH, "index.html", "/foo/bar/*", "servlet1");
    }

    @Test
    public void testTwo() {
        ServletSpecExampleTestCase.doTest("/foo/bar/index.bop", MappingMatch.PATH, "index.bop", "/foo/bar/*", "servlet1");
    }

    @Test
    public void testThree() {
        ServletSpecExampleTestCase.doTest("/baz", MappingMatch.PATH, "", "/baz/*", "servlet2");
    }

    @Test
    public void testFour() {
        ServletSpecExampleTestCase.doTest("/baz/index.html", MappingMatch.PATH, "index.html", "/baz/*", "servlet2");
    }

    @Test
    public void testFive() {
        ServletSpecExampleTestCase.doTest("/catalog", MappingMatch.EXACT, "catalog", "/catalog", "servlet3");
    }

    @Test
    public void testSix() {
        ServletSpecExampleTestCase.doTest("/catalog/index.html", MappingMatch.DEFAULT, "", "/", "default");
    }

    @Test
    public void testSeven() {
        ServletSpecExampleTestCase.doTest("/catalog/racecar.bop", MappingMatch.EXTENSION, "catalog/racecar", "*.bop", "servlet4");
    }

    @Test
    public void testEight() {
        ServletSpecExampleTestCase.doTest("/index.bop", MappingMatch.EXTENSION, "index", "*.bop", "servlet4");
    }

    private static void doTest(String path, MappingMatch mappingMatch, String matchValue, String pattern, String servletName) {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext" + path);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            String expected = String.format("Mapping match:%s\nMatch value:%s\nPattern:%s\nServlet:%s", mappingMatch.name(), matchValue, pattern, servletName);
            Assert.assertEquals((Object)expected, (Object)response);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

