/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.push;

import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.PushCallback;
import io.undertow.client.UndertowClient;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.protocol.http.AlpnOpenListener;
import io.undertow.server.protocol.http2.Http2OpenListener;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.push.PushServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.SingleByteStreamSinkConduit;
import io.undertow.util.SingleByteStreamSourceConduit;
import io.undertow.util.StringReadChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
public class PushPromisesTestCase {
    private static final AttachmentKey<String> RESPONSE_BODY = AttachmentKey.create(String.class);
    private static OpenListener openListener;
    private static ChannelListener acceptListener;
    private static XnioWorker worker;

    private static ChannelListener<StreamConnection> wrapOpenListener(ChannelListener<StreamConnection> listener) {
        return channel -> {
            channel.getSinkChannel().setConduit((StreamSinkConduit)new SingleByteStreamSinkConduit(channel.getSinkChannel().getConduit(), 10000));
            channel.getSourceChannel().setConduit((StreamSourceConduit)new SingleByteStreamSourceConduit(channel.getSourceChannel().getConduit(), 10000));
            listener.handleEvent(channel);
        };
    }

    @BeforeClass
    public static void setup() throws Exception {
        XnioWorker xnioWorker;
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", PushServlet.class).addMappings(new String[]{"/index.html", "/resources/*"});
        DeploymentInfo info = new DeploymentInfo().setClassLoader(PushPromisesTestCase.class.getClassLoader()).setContextPath("/push-example").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("push-example.war").addServlet(s);
        DeploymentManager manager = container.addDeployment(info);
        manager.deploy();
        root.addPrefixPath(info.getContextPath(), manager.start());
        openListener = new Http2OpenListener(DefaultServer.getBufferPool(), OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true, (Option)UndertowOptions.HTTP2_PADDING_SIZE, (Object)10));
        acceptListener = ChannelListeners.openListenerAdapter(PushPromisesTestCase.wrapOpenListener((ChannelListener<StreamConnection>)new AlpnOpenListener(DefaultServer.getBufferPool()).addProtocol("h2", (DelegateOpenListener)openListener, 10)));
        openListener.setRootHandler((HttpHandler)root);
        DefaultServer.startSSLServer((OptionMap)OptionMap.EMPTY, (ChannelListener)acceptListener);
        Xnio xnio = Xnio.getInstance();
        worker = xnioWorker = xnio.createWorker(null, OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client").getMap());
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        openListener.closeConnections();
        DefaultServer.stopSSLServer();
    }

    private PushCallback createPushCallback(final Map<String, ClientResponse> responses, final CountDownLatch latch) {
        return new PushCallback(){

            public boolean handlePush(ClientExchange originalRequest, ClientExchange pushedRequest) {
                pushedRequest.setResponseListener((ClientCallback)new ResponseListener(responses, latch));
                return true;
            }
        };
    }

    private ClientCallback<ClientExchange> createClientCallback(final Map<String, ClientResponse> responses, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ResponseListener(responses, latch));
                result.setPushHandler(PushPromisesTestCase.this.createPushCallback(responses, latch));
            }

            public void failed(IOException e) {
                e.printStackTrace();
                latch.countDown();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPushPromises() throws Exception {
        URI uri = new URI(DefaultServer.getDefaultServerSSLAddress());
        UndertowClient client = UndertowClient.getInstance();
        final ConcurrentHashMap responses = new ConcurrentHashMap();
        final CountDownLatch latch = new CountDownLatch(3);
        final ClientConnection connection = (ClientConnection)client.connect(uri, worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath("/push-example/index.html");
                    request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                    connection.sendRequest(request, PushPromisesTestCase.this.createClientCallback(responses, latch));
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)3L, (long)responses.size());
            Assert.assertTrue((boolean)responses.containsKey("/push-example/index.html"));
            Assert.assertEquals((long)200L, (long)((ClientResponse)responses.get("/push-example/index.html")).getResponseCode());
            Assert.assertNotNull((Object)((ClientResponse)responses.get("/push-example/index.html")).getAttachment(RESPONSE_BODY));
            Assert.assertTrue((boolean)responses.containsKey("/push-example/resources/one.js"));
            Assert.assertEquals((long)200L, (long)((ClientResponse)responses.get("/push-example/resources/one.js")).getResponseCode());
            Assert.assertNotNull((Object)((ClientResponse)responses.get("/push-example/resources/one.js")).getAttachment(RESPONSE_BODY));
            Assert.assertTrue((boolean)responses.containsKey("/push-example/resources/one.css"));
            Assert.assertEquals((long)200L, (long)((ClientResponse)responses.get("/push-example/resources/one.css")).getResponseCode());
            Assert.assertNotNull((Object)((ClientResponse)responses.get("/push-example/resources/one.css")).getAttachment(RESPONSE_BODY));
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    private static class ResponseListener
    implements ClientCallback<ClientExchange> {
        private final Map<String, ClientResponse> responses;
        private final CountDownLatch latch;

        ResponseListener(Map<String, ClientResponse> responses, CountDownLatch latch) {
            this.responses = responses;
            this.latch = latch;
        }

        public void completed(final ClientExchange result) {
            this.responses.put(result.getRequest().getPath(), result.getResponse());
            new StringReadChannelListener(result.getConnection().getBufferPool()){

                protected void stringDone(String string) {
                    result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                    latch.countDown();
                }

                protected void error(IOException e) {
                    e.printStackTrace();
                    latch.countDown();
                }
            }.setup(result.getResponseChannel());
        }

        public void failed(IOException e) {
            e.printStackTrace();
            this.latch.countDown();
        }
    }
}

