/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.ssl;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.SSLHeaderHandler;
import io.undertow.servlet.test.security.ssl.SSLMetaDataTestCase;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.ProxyIgnore;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@ProxyIgnore
@RunWith(value=DefaultServer.class)
public class SSLMetaDataProxyTestCase
extends SSLMetaDataTestCase {
    private static final String DUMMY_KEYSTORE = "dummy.keystore";
    private static final String DUMMY_PASSWORD = "password";
    private static X509Certificate dummyCertificate = null;

    @BeforeClass
    public static void setup() throws Exception {
        PathHandler root = SSLMetaDataProxyTestCase.setupPathHandler();
        SSLHeaderHandler sslHeaders = new SSLHeaderHandler((HttpHandler)root);
        DefaultServer.setRootHandler((HttpHandler)sslHeaders);
        InputStream stream = SSLMetaDataTestCase.class.getClassLoader().getResourceAsStream(DUMMY_KEYSTORE);
        KeyStore dummyKeystore = KeyStore.getInstance("JKS");
        dummyKeystore.load(stream, DUMMY_PASSWORD.toCharArray());
        dummyCertificate = (X509Certificate)dummyKeystore.getCertificate("dummy");
    }

    @Test
    public void testWithHeaders() throws Exception {
        Base64.Encoder encoder = Base64.getMimeEncoder();
        Object cert = "-----BEGIN CERTIFICATE----- " + encoder.encodeToString(dummyCertificate.getEncoded()) + " -----END CERTIFICATE-----";
        cert = ((String)cert).replace("\r\n", " ");
        String id = "1633d36df6f28e1325912b46f7d214f97370c39a6b3fc24ee374a76b3f9b0fba";
        String cipher = "ECDHE-RSA-AES128-GCM-SHA256";
        String keySize = "128";
        Header[] headers = new Header[]{new BasicHeader("SSL_SESSION_ID", id), new BasicHeader("SSL_CLIENT_CERT", (String)cert), new BasicHeader("SSL_CIPHER", cipher), new BasicHeader("SSL_CIPHER_USEKEYSIZE", keySize)};
        String response = this.internalTest("/cert-dn", headers);
        Assert.assertEquals((Object)dummyCertificate.getSubjectDN().toString(), (Object)response);
        response = this.internalTest("/id", headers);
        Assert.assertEquals((Object)id, (Object)response);
        response = this.internalTest("/cipher-suite", headers);
        Assert.assertEquals((Object)cipher, (Object)response);
        response = this.internalTest("/key-size", headers);
        Assert.assertEquals((Object)keySize, (Object)response);
    }

    @Test
    public void testNoCertWithHeaders() throws Exception {
        String cert = "(null)";
        String id = "1633d36df6f28e1325912b46f7d214f97370c39a6b3fc24ee374a76b3f9b0fba";
        String cipher = "ECDHE-RSA-AES128-GCM-SHA256";
        Header[] headers = new Header[]{new BasicHeader("SSL_SESSION_ID", id), new BasicHeader("SSL_CLIENT_CERT", cert), new BasicHeader("SSL_CIPHER", cipher)};
        String response = this.internalTest("/cert-dn", headers);
        Assert.assertEquals((Object)"null", (Object)response);
        response = this.internalTest("/id", headers);
        Assert.assertEquals((Object)id, (Object)response);
        response = this.internalTest("/cipher-suite", headers);
        Assert.assertEquals((Object)cipher, (Object)response);
        response = this.internalTest("/key-size", headers);
        Assert.assertEquals((Object)"0", (Object)response);
    }
}

